const database = require("../../app/configs/database.js");

class model extends database {

	constructor() {
		super();
	}

	setTransaction(trx) {
		this.trx = trx;
		return this;
	}

	async findOne(params=false) {
		const qb = this.table(this.table_name);
		const filters = [];
		var noSelect = true;
		var addLimit = true;

		filters.push(['whereRaw', `${this.table_name}.deleted_at is null`]);

		if(Number.isInteger( parseInt(params) )) {
			filters.push(['where', `${this.table_name}.${this.primary_key}`, params]);
		}

		if(Array.isArray(params)) {
			params.forEach((v, k)=>{
				if(
                    v.indexOf('select') > -1 || 
                    v.indexOf('count') > -1 || 
                    v.indexOf('sum') > -1
                ) noSelect = false;

                if(
                    v.indexOf('count') > -1 || 
                    v.indexOf('sum') > -1
                ) addLimit = false;
                
				filters.push(v);
			});
		}

		if(noSelect) {
			filters.push(['select', '*']);
		}

		if(addLimit) {
			filters.push(['limit', '1']);
		}

		filters.forEach((v, k)=>{
		    const params = Object.assign([], v);
		    params.splice(0,1);
		    qb[v[0]](...params);
		})
        const [data] = (await qb) || [];
		return data;
	}

	async findAll(params=false) {
		const qb = this.table(this.table_name);
		const filters = [];
		var noSelect = true;
		filters.push(['whereRaw', `${this.table_name}.deleted_at is null`]);

		if(Number.isInteger( parseInt(params) )) {
			filters.push(['where', `${this.table_name}.${this.primary_key}`, params]);
		}

		if(Array.isArray(params)) {
			params.forEach((v, k)=>{
				if(v.indexOf('select') > -1) noSelect = false;
				filters.push(v);
			});
		}

		if(noSelect) {
			filters.push(['select', '*']);
		}

		filters.forEach((v, k)=>{
		    const params = Object.assign([], v);
		    params.splice(0,1);
		    qb[v[0]](...params);
		})
		return qb;
	}

	async _allowed_fields(data) {
		var fields = new Object();
		Object.keys(data).forEach((v)=>{
		    if(this.allowed_fields.indexOf(v) >= 0) {
		    	fields[v] = data[v];
		    }
		})
		return fields;
	}

	async insert(data) {
		data = await this._allowed_fields(data);

		if(typeof this.use_timestamp == 'boolean' && this.use_timestamp) {
			data[this.createdField] = new Date();
		}

		const qb = this.table(this.table_name);
		if(typeof this.trx !== 'undefined') qb.transacting(this.trx)
		return await qb.insert(data);
	}

	async update(id, data) {
		data = await this._allowed_fields(data);

		if(typeof this.use_timestamp == 'boolean' && this.use_timestamp) {
			data[this.updatedField] = new Date();
		}

		const qb = this.table(this.table_name);
		if(typeof this.trx !== 'undefined') qb.transacting(this.trx)
		if(Number.isInteger( parseInt(id) )) {
			var whereId = new Object();
			whereId[`${this.table_name}.${this.primary_key}`] = id;
			qb.where(whereId)
		} else {
			qb.where(id);
		}
		return await qb.update(data);
	}

	async batchUpdate(params="", data) {
		const qb = this.table(this.table_name);
		const filters = [];

		if(typeof this.use_timestamp == 'boolean' && this.use_timestamp) {
			data[this.updatedField] = new Date();
		}

		filters.push(['whereRaw', `${this.table_name}.deleted_at is null`]);

		if(Number.isInteger( parseInt(params) )) {
			filters.push(['where', `${this.table_name}.${this.primary_key}`, params]);
		}

		if(Array.isArray(params)) {
			params.forEach((v, k)=>{                
				filters.push(v);
			});
		}

		filters.forEach((v, k)=>{
		    const params = Object.assign([], v);
		    params.splice(0,1);
		    qb[v[0]](...params);
		})
		
		return await qb.update(data);
	}

	async delete(id) {
		const qb = this.table(this.table_name);

		if(typeof this.use_soft_delete == 'boolean' && this.use_soft_delete) {
			const data = new Object();

			if(typeof this.use_timestamp == 'boolean' && this.use_timestamp) {
				data[this.deletedField] = new Date();
			}

			if(typeof this.trx !== 'undefined') qb.transacting(this.trx)
			if(Number.isInteger( parseInt(id) )) {
				var whereId = new Object();
				whereId[`${this.table_name}.${this.primary_key}`] = id;
				qb.where(whereId)
			} else {
				qb.where(id);
			}

			return await qb.update(data);
		} else {
			if(typeof this.trx !== 'undefined') qb.transacting(this.trx)
			if(Number.isInteger( parseInt(id) )) {
				var whereId = new Object();
				whereId[`${this.table_name}.${this.primary_key}`] = id;
				qb.where(whereId)
			} else {
				qb.where(id);
			}

			return await qb.del();
		}
	}

}

module.exports = model;