exports.invoices = ($) => {
	const __constructor = async function(req, res) {
		try {
			return res.renderMemberArea("bills/invoices");
		} catch (err) {
			return res.status(500).json({'message': 'server unavailable'});
		}
	}

	return __constructor;
}

exports.invoice = ($) => {
	const __constructor = async function(req, res) {
		try {
			const code = $.helper('text').sanitize_alphanum(req.params.code);
			const bill = await $.model('bills').findOne([
				['where', 'invoice', '=', code]
			]);
			if(bill) {
				const bank = await $.model('banks').findOne([
					['where', 'id', '=', bill.bank_id]
				]);
				const userdata = await $.model('users').findOne([
					['where', 'id', '=', bill.user_id]
				]);
				return res.renderMemberArea("bills/invoice", {
					bill: bill,
					bank: bank,
					userdata: userdata,
				});
			} else {
				return res.status(404).json({
					message: 'Page not found!'
				});
			}
		} catch (err) {
			return res.status(500).json({'message': 'server unavailable'});
		}
	}

	return __constructor;
}

exports.request = ($) => {
	const __constructor = async function(req, res) {
		try {
			return res.renderMemberArea("bills/request");
		} catch (err) {
			return res.status(500).json({'message': 'server unavailable'});
		}
	}

	return __constructor;
}