const moment = require("moment");

exports.login = ($) => {
	const __constructor = async function(req, res) {
		try {
			res.clearCookie($.config("app").session_name);
			return res.render("auth/login", {
				layout: "auth"
			});
		} catch(err) {
			console.log(err);
			return res.status(500).json({'message': 'server unavailable'});
		}
	}

	return __constructor;
}

exports.forgot = ($) => {
	const __constructor = async function(req, res) {
		try {
			res.clearCookie($.config("app").session_name);
			return res.render("auth/forgot", {
				layout: "auth"
			});
		} catch(err) {
			console.log(err);
			return res.status(500).json({'message': 'server unavailable'});
		}
	}

	return __constructor;
}

exports.register = ($) => {
	const __constructor = async function(req, res) {
		try {
			res.clearCookie($.config("app").session_name);
			return res.render("auth/register", {
				layout: "auth"
			});
		} catch(err) {
			console.log(err);
			return res.status(500).json({'message': 'server unavailable'});
		}
	}

	return __constructor;
}

exports.new_password = ($) => {
	const __constructor = async function(req, res) {
		try {
			res.clearCookie($.config("app").session_name);
			const tokenParam = $.helper('text').sanitize_alphanum(req.params.token);
			const token = await $.model('tokens').findOne([
				['where', 'token', tokenParam],
				['where', 'expired_at', '>=', moment().format('YYYY-MM-DD HH:mm:ss')]
			]);
			if(token) {
				return res.render("auth/new_password", {
					layout: 'auth',
					token: tokenParam
				});
			} else {
				return res.status(404).json({'message': 'Tautan kadaluarsa'});
			}
		} catch(err) {
			console.log(err);
			return res.status(500).json({'message': 'server unavailable'});
		}
	}
	
	return __constructor;
}

exports.logout = ($) => {
	const __constructor = async function(req, res) {
		try {
			res.clearCookie($.config("app", "session_name"));
			return res.redirect( $.base_url('auth/login'));
		} catch(err) {
			console.log(err);
			return res.status(500).json({'message': 'server unavailable'});
		}
	}
	return __constructor;
}