const pwhash = require('password-hash');
const fs = require('fs');
const path = require('path');
const uniqid = require('uniqid');
const sharp = require('sharp');

exports.update = ($) => {
	const __constructor = async function(req, res) {		
		try {

			if(req.validate.isEmpty()) {

				const usernameCheck = await $.model('users').findOne([
					['where', 'username', req.body.username],
					['where', 'id', '!=', req.auth.user('id')]
				]);

				if(usernameCheck) {
					return res.status(400).json({
						message: "Periksa kembali form anda.",
						errors: {
							username: 'Username sudah digunakan.',
						}
					});
				}

				const emailCheck = await $.model('users').findOne([
					['where', 'email', req.body.email],
					['where', 'id', '!=', req.auth.user('id')]
				]);

				if(emailCheck) {
					return res.status(400).json({
						message: "Periksa kembali form anda.",
						errors: {
							email: 'Email sudah digunakan'
						}
					});
				}

				var pw = req.body.password;
				var pwc = req.body.password_confirm;
				var update_password = false;

				if(pw.length > 0 || pwc.length > 0) {

					if (pw === pwc) {
						pw = pwhash.generate(pw);
						update_password = true;
					} else {
						return res.status(400).json({
							message: "Periksa kembali form anda.",
							errors: {
								password_confirm: 'Kata sandi tidak sesuai.'
							}
						});
					}

				}


				var formdata = {
					name: req.body.name.replace(/[^0-9A-Za-z\s]/g, ''),
					username: req.body.username.toLowerCase().replace(/[^0-9a-z]/g, ''),
					email: req.body.email.toLowerCase().replace(/[^0-9a-z\@\.\_\-]/g, ''),
					phone: req.body.phone.replace(/[^0-9]/g, "")
				};


				if(typeof req.body.photo !== 'undefined') {
					const ext = path.extname(req.body.photo.path);

					if(!['.png', '.jpeg', '.jpg'].includes(ext)) {
						throw 'uploaded file not supported.'
					}

					const filename = `${uniqid()}.jpeg`;

					await sharp(req.body.photo.path)
					.resize(300, 300)
					.jpeg(75)
					.toFile(`./public/uploads/profiles/${filename}`)
					.then( data => { 
						formdata.photo = filename;
					})
					.catch( err => { 
						console.log(err);
					});
				}

				if(update_password) {
					formdata = Object.assign({}, formdata, {
						password: pw
					});
				}

				await $.model('users').update(req.auth.user('id'), formdata);
				return res.json({
					message: "Berhasil memperbarui profil"
				});
			} else {
				return res.status(400).json({
					message: "Periksa kembali form anda.",
					errors: req.validate.get_errors()
				});
			}
		} catch (err) {
			console.log(err);
			return res.status(500).json({message: 'error tidak diketahui'});
		}

	}

	return __constructor;
}