exports.datatables = ($) => {

	const __constructor = async function(req, res) {

		const datatable = $.library('datatables');

		try {
			datatable.init('banks');
			datatable.rest(req, res);
			datatable.search('mode', 'name', 'account_name', 'account_address', 'status', 'id');
			datatable.params([
				['select', 'mode', 'name', 'account_name', 'account_address', 'status', 'id'],
				['where', 'id', '>', '1']
			]);
			return await datatable.render();
		} catch(err) {
			res.status(500).json({
				message: err
			});
		}
	}

	return __constructor;
}

exports.create = ($) => {

	const __constructor = async function(req, res) {
		try {
			if(req.validate.isEmpty()) {
				
				const data = {
					name: req.body.name, 
					account_name: req.body.account_name, 
					account_address: req.body.account_address, 
					mode: req.body.mode,
					status: req.body.status
				};

				await $.model('banks').insert(data);
				return res.json({
					message: "Data ditambahkan!"
				});
			} else {
				return res.status(400).json({
					message: "Periksa kembali form anda.",
					errors: req.validate.get_errors()
				});
			}
		} catch(err) {
			console.log(err);
			return res.status(500).json({message: 'error tidak diketahui'});
		}
	}

	return __constructor;
}

exports.update = ($) => {

	const __constructor = async function(req, res) {
		try {
			if(req.validate.isEmpty()) {
				const id = $.helper('text').sanitize_int(req.params.id);
				const data = {
					name: req.body.name, 
					account_name: req.body.account_name, 
					account_address: req.body.account_address, 
					mode: req.body.mode,
					status: req.body.status
				};

				await $.model('banks').update(id, data);
				return res.json({
					message: "Perubahan disimpan!"
				});
			} else {
				return res.status(400).json({
					message: "Periksa kembali form anda.",
					errors: req.validate.get_errors()
				});
			}
		} catch(err) {
			console.log(err);
			return res.status(500).json({message: 'error tidak diketahui'});
		}
	}

	return __constructor;
}