/* Copyright 2021-2023 Ethan Halsall. This file is part of wasm-audio-decoders. https://github.com/eshaz/wasm-audio-decoders */
var t,s;t=this,s=function(t,s){function e(){const t=Uint8Array,s=Float32Array;e.t||Object.defineProperties(e,{t:{value:new WeakMap},o:{value(t,s){e.t.set(t,Promise.resolve(s))}},l:{value(t,s){let i=e.t.get(t);return i||(s?i=WebAssembly.compile(e.u(s)):(s=t.U,i=e.M(s).then((t=>WebAssembly.compile(t)))),e.t.set(t,i)),i}},p:{value(t,e){let i=new s(e),r=0,n=0;for(;r<t.length;)i.set(t[r],n),n+=t[r++].length;return i}},m:{value:(t,s,e,i,r)=>({_:t,channelData:s,samplesDecoded:e,sampleRate:i,bitDepth:r})},T:{value(t,s,i,r,n,h){let o,a,l=[];for(o=0;o<i;o++){const t=[];for(a=0;a<s.length;)t.push(s[a++][o]||[]);l.push(e.p(t,r))}return e.m(t,l,r,n,h)}},$:{value:(()=>{let t,s,e,i=new Int32Array(256);for(t=0;t<256;t++){for(e=t<<24,s=8;s>0;--s)e=2147483648&e?e<<1^79764919:e<<1;i[t]=e}return i})()},u:{value(s){let i,r,n,h=new t(s.length),o=parseInt(s.substring(11,13),16),a=256-o,l=!1,c=0,u=21,d=4294967295;for(;u<s.length;u++)if(r=s.charCodeAt(u),61!==r||l){if(92===r&&u<s.length-5){const t=s.charCodeAt(u+1);117!==t&&85!==t||(r=parseInt(s.substring(u+2,u+6),16),u+=5)}l&&(l=!1,r-=64),h[c]=r<o&&r>0?r+a:r-o,d=d<<8^e.$[255&(d>>24^h[c++])]}else l=!0;for(i=0;i<=8;i+=2)n|=parseInt(s.substring(13+i,15+i),16)<<4*i;if(n!==d)throw Error("WASM string decode failed crc32 validation");return h.subarray(0,c)}},M:{value(s){return s=e.u(s),new Promise((i=>{const r=String.raw`dynEncode0114db91da9bu*ttt$#U¤¤U¤¤3yzzss|yusvuyÚ&4<054<,5T44^T44<(6U~J(44< ~A544U~6J0444545 444J0444J,4U4UÒ7U454U4Z4U4U^/6545T4T44BU~64CU~O4U54U~5 U5T4B4Z!4U~5U5U5T4U~6U4ZTU5U5T44~4O4U2ZTU5T44Z!4B6T44U~64B6U~O44U~4O4U~54U~5 44~C4~54U~5 44~5454U4B6Ub!444~UO4U~5 U54U4ZTU#44U$464<4~B6^4<444~U~B4U~54U544~544~U5 µUä#UJUè#5TT4U0ZTTUX5U5T4T4Uà#~4OU4U $~C4~54U~5 T44$6U\!TTT4UaT4<6T4<64<Z!44~4N4<U~5 4UZ!4U±_TU#44UU6UÔ~B$544$6U\!4U6U¤#~B44Uä#~B$~64<6_TU#444U~B~6~54<Y!44<_!T4Y!4<64~444~AN44<U~6J4U5 44J4U[!U#44UO4U~54U~5 U54 7U6844J44J 4UJ4UJ04VK(44<J44<J$4U´~54U~5 4U¤~5!TTT4U$5"U5TTTTTTT4U$"4VK,U54<(6U~64<$6_!4< 64~6A54A544U~6#J(U54A4U[!44J(44#~A4U6UUU[!4464~64_!4<64~54<6T4<4]TU5 T4Y!44~44~AN4U~54U~54U5 44J(44J UÄA!U5U#UôJU"UÔJU#UÔ"JU#U´"JT4U´ZTU5T4UôZTU5T4UDZTU5T4U$[T44~UO4U~5 UÔUô4U~U´$.U5T4UP[T4U~4~UO4U~5 U#<U#<4U~U2$.UÄUN 44 ~UO4U~5 44!~UO4U~5 4U~4~UO4U~5 44J44J(U5 44U¤~J@44Uä~J<44UD~J844U~J44U$54U$5U54U$54U1^4U1^!4U~54U~5U54U~6U4U^/65T4T4U$54U~4BU~4O4U54U~5 UU'464U'_/54UU~5T4T4U~4BU~UO4U54U~5 U54Uä~4U¤~4U~U'$!44~5U5T44\T44U<~$6U\!4U#aT4U~4U~4O4U~5 U5U5U5TTT4U$"4YTU5 4U4~C5U5 U5U5444$4~64~\TU5 4U~4U~5T4Y!44O4U~54U~54U5 4CYTU5 4Uä~4U¤~4U~4$6TU54U\!44Bæ4Bä~[!4U~4UD~4U~4U~4$6TU54U\!44B4B~[!44U<~4U4~$5 4U"U#$544"Y!454U^!44<J44<(J454U~84­UN!#%'+/37?GOWgw·×÷Uä;U9$%& !"#`;e.l(e,r).then((t=>WebAssembly.instantiate(t,{}))).then((({exports:e})=>{const r=new Map(Object.entries(e)),n=r.get("puff"),h=r.get("memory").buffer,o=new t(h),a=new DataView(h);let l=r.get("__heap_base");const c=s.length,u=l;l+=4,a.setInt32(u,c,!0);const d=l;l+=c,o.set(s,d);const U=l;l+=4,a.setInt32(U,o.byteLength-l,!0),n(l,U,d,u),i(o.slice(l,l+a.getInt32(U,!0)))}))}))}}}),Object.defineProperty(this,"U",{enumerable:!0,get:()=>this.P}),this.v=(t,s,e)=>{let i=[],r=0;for(;r<s;)i.push(t.slice(r*e,r++*e+e));return i},this.A=(t,s,e=!0)=>{const i=this.P.O(s.BYTES_PER_ELEMENT*t);return e&&this.C.add(i),{S:i,D:t,N:new s(this.P.J,i,t)}},this.free=()=>{this.C.forEach((t=>{this.P.free(t)})),this.C.clear()},this.L=t=>{const s=[],e=new Uint8Array(this.P.J);for(let i=e[t];0!==i;i=e[++t])s.push(i);return String.fromCharCode.apply(null,s)},this.I=(t,s,e,i,r,n)=>{t.push({message:s,frameLength:e,frameNumber:i,inputBytes:r,outputSamples:n})},this.instantiate=(t,s)=>(s&&e.o(t,s),this.P=new t(e).instantiate(),this.C=new Set,this.P.ready.then((()=>this)))}class i extends((()=>globalThis.Worker||s)()){constructor(t,s,i,r){e.t||new e;let n=e.t.get(i);if(!n){let t,s="text/javascript",h=`'use strict';(${""+((t,s,e)=>{let i,r,n=new Promise((t=>{r=t}));self.onmessage=({data:{id:h,command:o,data:a}})=>{let l,c=n,u={id:h};"init"===o?(Object.defineProperties(t,{B:{value:s},W:{value:e},module:{value:a.module},V:{value:!0}}),i=new t(a.options),r()):"free"===o?i.free():"ready"===o?c=c.then((()=>i.ready)):"reset"===o?c=c.then((()=>i.reset())):(Object.assign(u,i[o](Array.isArray(a)?a.map((t=>new Uint8Array(t))):new Uint8Array(a))),l=u.channelData?u.channelData.map((t=>t.buffer)):[]),c.then((()=>self.postMessage(u,l)))}})})(${i}, ${e}, ${r})`;try{t=void 0!==process.versions.node}catch{}n=t?`data:${s};base64,${Buffer.from(h).toString("base64")}`:URL.createObjectURL(new Blob([h],{type:s})),e.t.set(i,n)}super(n,{name:s}),this.G=Number.MIN_SAFE_INTEGER,this.R=new Map,this.onmessage=({data:t})=>{const{id:s,...e}=t;this.R.get(s)(e),this.R.delete(s)},new r(e).l().then((s=>{this.q("init",{module:s,options:t})}))}async q(t,s){return new Promise((e=>{this.postMessage({command:t,id:this.G,data:s}),this.R.set(this.G++,e)}))}get ready(){return this.q("ready")}async free(){await this.q("free").finally((()=>{this.terminate()}))}async reset(){await this.q("reset")}}const r=(t,s)=>{Object.defineProperty(t,"name",{value:s})};function n(t){function s(){}for(var e=new Uint8Array(123),i=25;i>=0;--i)e[48+i]=52+i,e[65+i]=i,e[97+i]=26+i;var r,h;e[43]=62,e[47]=63,n.U||Object.defineProperty(n,"U",{get:()=>String.raw`dynEncode01b1ed4f83e2-3÷ÁÞeeägü{7JÅÿ÷w¼7äctýwpÃoñäyº=MB*Z,½|ÐMò±qp"tCì\ðauôudüÅÔwQ#åJ÷ôÍ¹©Ö/jµ·R«®M®ÛGv
ñJ= e>çFÛ][7àlÜÏ±!ÊHU¢É²©Ûép@9J=Mve1cMÖD5Ò(u9¶]wæêWöBÃGIã±UÚ1{â¤_ülµöSÕö­D°åxd®¬0dëx¹¡&é9 qï-Ä§aÐ!±,<XÂ;½Rô@\÷Ho&¬ÿRìÜ!À	ëº	N^:Xs&Û:Q8d7À³MNì2ÈAi \ÓÈB¹ýºª$¿ª]+jÛÁ­ÄÃÉ¸À~Wù/¢,,åÅ7µÛ¼4Òÿ4µ&òëB+ïP\eÁïQÄ£:là=M¨ØÙRmWd×@,¹³ô_ÖÙ ÚègËKeåâegVf7çgeeÒú½ÞgeOGâ¥ñüÀÉ+UVø½îÄ7Oôh¥mèt{åæÕzBaSa5Æì,ji´Ks{t÷"¿=MdRÌ(gì¹P¶åõ³Ê2 ÍïÌâ0Ïs¬S¿­05%GW3,ÛÁSÅÕOÊ§x¸Ðzt§
Â¾sÁc£¼¦p\!ðð÷÷¿åLÔ;#üÿ§
ê¹è¾s>GK	ÛíÊ¸e"ñ¾úM¢,w¨Ì&ÛÈD'ËìÚÚhµÄÆ:3 xRÜì¬³#-= aîØ©"4¸Ë,æs3Ö+6Ùÿ¼RÞ¢>wHª;zìñ¡MM_V¬S×K_­Ü®¥è¥¼ÔxÍ)MÈÔ®|?/Òü¢)åqÜ¢hÃå£¼dï[!±dá}bÃap[µ¶e¸)¼Áþß®;_tÚ4QÇfbÍ^o¬«ñþGv>þÞ]hoñ®Ë¦²¤Ê#äiÁ×ïÃHê¨»¡éCÝ~}]}]]{[ZÃh®ÓÝt¥)¨=}÷(ixf§Í.!m½
æÑhU|$hîÍ¡/ãää4n}§®0mYûz!å®jÓä<ø¢ÙÓæ×³uüÒ[²OìºOHjPnÎ5ÇçÎt®-Ê7w}´0½½T"v9c
¯JÅ,LÄäµh]Ð_]IÍ=}JàÝeþ²§>Ìè¯¦xôçÝ õ= aÛÀÂTÿ¢ù$¦êÛJîÃÜ¼lô]¥²Ýá¦aÿBÅËûéÚÕ°l>à´ Z%øC<FM1=MåÂC¹pó±ÕÃäyÐ=}wl0Ý[Íá Ú°øäã´pt%JßÞ´ûd°m<
~qv¥êÝÏ'E3ò{ÆºDâ°f¡4c¼ÜL
m2_<èàÃ°þmWö\eÕ|ÁFdVT ÜäÐ3á®\tëýf§ f}Wl.?æÌ')·¢WÞÊhðD¿hÐüiøE_%g=}<ÚÉé÷_ä­s|1æÑ	a¾üòÞDú{Þ4ÆD~³ól¿´A,]E_JBjoi{ð$záù$QÚßuD½32¼c¼\/áL¶lBó®ßZf§T1µeÃCâà'DtB>ÑûÈàôÏô&W# ÍKó£ýjÈ!´´G)åÔ±¡ïç.±ËI2Î3ì[-µx)¬xxDÍ|³YtÀ 9oò/2(»¡PW]j¦jÆ7U¸ÈÕjøcN¬p<}>vî¦îJ
<ÙxôçæÌq4¥öÈ0ÀdH/fd/ ìk°Öj±
j}]È2'ú8Þhiq¦¿= »8R¦L½WõþD-.\ÚóñÑâæms;çº_%¿6$|og)Ü vY6Wóuèý}Ú8EJDÝÚZVÎÉªÁÝÎéÚzGå_Ê¬&DÙ	n$JCaÛ¨fï ãµ>´ÃÞËÁÞ§SFp[NÄþ0Z<Ðß·Bt¹Ä@N'ÊäAgZ&¾,q·ý4ªU]ÌýXÔzvß«¦8e!ÔDµÀrã&ö§¥õýxÕÐ*L±BC2	c<,FêtÔWõ¥É¹·eÃö,ÖPÒip²!Ù4nÕ´£WI	f?ñ¿N>VUd­5tÂì]Ï;ò »åÄÉËYOxDÀáV©Á&­¦Ì$ëÍAðn®$h|Ó²vÿØysm hÉþOÿ²]iËüX<ìÏ<_d±}=MZU2|ÖÔ´Ñ4x×½û-G-ÊýÚïÔI:'f£_{¤±%<°ÙUQGy­k÷&¨à%aO¶ñø	ÉðÅêW7É´¿Î)ÚÃ»k,¨ÓÍ{©¥Âd)²JTBÚypQCß$(£þEã°Ãk2zPy7Çæ	õ÷g<+ÐÕ<&7üUöyC¬°}Ø h¶PñX~¾í2îØ= ÿ\÷Í¶Êû¤G}¥l¸Îú?y?OÆÎð)	BSsc¿G~¬(Þ:BdûV)ÁeíKô$ñÇp=Mdz\¬UDG#ÒÀ§ì¥¹&ÌOP¼[s§,èá.+E¥½8·ÐËQhNà¶:Ç?ÍZÈZ
hÍúüa
aÒÌJzµ±:Ô<9ÂW»ç¼ÐêPõÜñj±ÃDós8Ý&7×ájüÉKL_i7bb4fW6Rêæ.eJíI«ähS&k=M<åõÕ4ðÙb2ñW²­½±|eU½xÛ@=}8¿Ða·ûa<gGrRJ·AýQú2³h}ÂPVðûÛ©!.)O§kþCgå©E-Qy¦ïäpÐj¢>à® ê°ïaõi¡Àâ/s ê«@åDd6°üÉ=}OCSg,RDÜÜQ89ôµÈNè¤Ö¶uD}0Þd±6H}dBóÆóÐfqo6CV°{¿°êb§Àr©!å#l¢V>záTw8ã-ÐCÞ
-P
¥XÿôvuíÛYRÛrnÉ¤Fè2óUô÷ösôbå]¸²¦"k^Òkx9<Y½~¦,P§åz&øAëAÝTut-s´'òÇ¶£túY°@Ñ³OImM}ÍfQJùÓ_²é¿-Èñæ*nù\±#Â|F<ZÏI}\%ôfFËxL×)õZæD=MyÉawæ/PËqüÞ=MäÕp7ÖÀý©eA!¢9ïP¼Â£¾ à(Pëº$M¤Ä;ÉG¸s¶º(Ùj%DYãÓ'gfÖ:®êýy3Yè·àÆþLÔ3óüÆüÉj¬Ù5jÚ¶mg©= ÷[ç.xäôÎ×¿2¡ ôãæ~Ûtuï&ÐV mfXú?&ò(CýûK=M¯ÚI'>ØP7·Ï\ïÝebèÙ:UîbýÃ|}Jä,×/_çì	¤^îhølöa= l{/½¢<K¹©Jý±TNa§VRÜ.6.»è¿C~_QIcÙÁü ¦Ókù¤¿¿	ù¨#Hk÷äüåá,÷æ·ä(ÿBoÔaiJYÉ&1¢roÉª?y 1ô®ìF°-lÀ[ü¢È£¬£m;Òå¼ÍÃ£ë*V ÉPòNE¸UÈh¬ù"¼i-ºSÖæ¸ 'OêËÌk'åKPdg-vçÂ)x¬s©7Bõ²òp««×ié M tK·PB´mZë£õq9T}®_Î\úÔkçTª/mx,Ï5tÐ-÷Àé9zÄ;öõ '±A7= Fm_dì­PË¯Ïxè×Þà<ÓVÆÉýR
¯-ÈU«Hðªü®¯_ñïÅN$vØõDôÜuÓ!MR¶{Ö/ÉHò;¸gp¢Â³RÐ¶»	ìrok¶Cd8fþ:bCW¿xE+Z·¹úv½/
MlzØ1¾Pa§yvrJ)äê¨EåÌåëiq«Gùï÷"QqçVþ°Ñ.£­Þqw¶r;Cíµzgm.:+°jkkÛÑ!Í 7w@(wÔï^wWm×Øè£Eì¹=MF%7£ÜÕþ_lsU+ý&à¬ ã?#W_)&vUø0ð/ôÔc~ª¥§ÏÔ1¹,Bð§Ô.î×8)e-Íj7l´¦Átcì@x4ó)ó)½©@õoÝl¤idzev6 AíS-]åö#Îëåp=}Â¨TpÏ¬%r)k>L¤Yvã<~)zuKþðÔ"E½2{^µ¯Ñçñ8¤û÷ì¢Z×¤WQiÁ5eôav¶¹¤æP« ¢Þ1q Ûnm?±çþ§þ= ´/}HRi ÄuÏ2Î=M«(pÁ2F·_È¥ñÐ Ù´Ä^îZ¢çð¦ÀÂL¨¸bAJCûß&wlUDºH(z czi dº!·®iE~± ájaú¡Â,+!ü;hîhÊ5d+%°>®©ª¨óØ®·½@hý¶L.Ó]'ì+;ÆI</á/d±s°n$ÈÆ³|3QP°±¢ðµ¹pTbb<àmi>óø¨ú_L´íè¬µ¬S,¤_b@¤ÉÎ"¨ßúXAxc?9hkÈÎó= UÂV	²NwÆ0Ð§Ð(Er²,#hÀ!ÆÙs=MpÃ«®Mþ¦RA´ÌCäÝFÒEQ¦©·úËìÁ=M("¯	ltÉðûÝ§L9ºUß®½_'ÂV~xjáäØà= ç~ÌÕv!úÀ ­+$µÊq)ñ?ñFcDF!wmBtêD+*(Ä¯gåYðW{æ.*»wúRï­ñKÉÂÂ»¡ Ëøòrñ%WP¹{ÍÊLè4WÔ 1Ú./	,õþÅJ¡¯zO×â4àYãYûºjÅÃ&éKME±zó¿¿ÄCuÉÈ ù$:U¾2ìæÛ¡Ä9|ÛäÝ¾õ÷0<Àêø~ò××0SãäsåÖÙ¥ª|þx°¥®¹pJ¼9\lÈá8mqG´bÀ7h8§FÆGGxñ8Lsà¸>p;m\o²yeèkPÛúHQOqP0pJEUÙðÖ#Fê²YTHþ¥&º$9å I¿î:0ÂQ z÷'ÊGgÜ­³,Ô<oß©î¾£nPÕ4= pÌýoW%¦elÜäxDPnÑë#áñQëÃ;2h=}Ø@ÃouupÉÁHû¤ãÄäQ0Ð(¨ÞþZòÜ!êµiüýÒþW¤Wwb@âÍq|}ÒXøêºµ¦b?GnÝ ó ¾?Oþ¯q.lX½,Ìí|à<å>Ô£E5ß«?VqpÏÓë¤(M|wD·DâùÒ,ÏÉl¯§½ôá|ÝÞñrt,·Cô@>j{.&ò(è¹ãøì×çMU t¯¨9  ®uH,]ÉÔ1)Qô¶Ð¯Õ8Æ$ZÅÑ2iC|ÔöimjàØÓ®ÈTD|nw×U*x¤Ä_NÿÃ«#[%Y¯àÃ»Ö~|Ú¨axø)×fÞ	ñ×åËtw¡ÆôMhòçÀ¥»3§=}&§|ïmÀ¥zÞ¶iÎÒ0T4×ÄeW=}= P-ëá«æwñr(ØàÀß´®ôqÜ!ñ¦'Õ@¸aùSh·ñL¢HGìB$_(ü£(ñi+mÖb%Öô¦¬ì´

Ír)8àãñ²¦ì)ç*À¾Gsd]IÉY4zmâ$yJ Ðµð¬®Pq½=MVHjO'0&{ÆJ(vÖUUl´®£é¼¸íáw?ÔçÏäDÞ:wigR¬uD±¦þ¿³´/¦©2l"®éÝÅx"³b¯­E¢} Õî{[0#1¸MÐÅ=}SL´=}p9: ´LÁ?P_>³VK|7RÏw*©17êJ¤KbåtßÞÓÈË.<È<ßE°3°±ùËà}KÝ@u(Ws ¹êUñr}ædÑ2âìü{ùâKñl°ÕÊj ¬B qÒÎÃNÑ Wòo:a9#ùZÚÜìõvDÅe¬ 4;xÖza1.à¿Ûê/DS&Z-Kcmq»aÎýïïGç¼.à³ìbð°|2[} "AÞjÈw3ÖàÐ³6.ð~*y,iXTlSPK¶w\§×BÈsA$h2õµl2á\6àëÿ" 7·t?@a?ç|=}3\¨Û³IðË¥Õ{G@3W«´¥	"èc[p×ÞñêoEUhÙêQÇG¥ÈmÈÄÎ9Íàd PÔÂÙ°ôí­%)ù§P¿Ï´NÒ½ì{/S´= é|%= #- ¥ËÃØÞÛ|n}Yì**¯vÊ{4$º\1»×·yé$ão,#Ôd,Î/ãN°Þª§úSç¿öìOu51«öÐ=}N= /¹í°NëWo¯ÞÆT¢Èt¥ êaÉ¦V+t~8©[3pvXÀ[?÷lUCG_å|3 Ú;yL+Db±/úçÉµÄá^!_Vfú­öÑZÁÕ=  [Ës3¶¦á§¿<#¥K·¼3(íGÆ&-!¸Ìä@\2AºUì£HV|[¥nÖV îÝ¬êMâ*ó¶~J4 9ÂeVe:#g8M,I§©,¨æè*8Hù ¿³êÒ6(Ö6Ü¥§u:uAv{§-^2¹k/a8Fm:]ÔCÊã¡*7¿9Ósä½$®uZi"çÎ¶i~²*±ºC|ugáÂWª
eq)¯;~$UÂmN$¨ÉlPì8[;?Ü¬Æ9ãßl,e¸0.¡ã¢1 o·=M¡b<'2$ä= Wl½¨ø¨«&!HvÞÏ·
q£"
reûiçê¢·ë?»|Ç]+èËjæù¾Ñ/õ0·Ä/¬Á;µ<®ØÖðÊØgêæô¡d¼¸'èÆ"ä7HTB¡¨K¡ü{×/S¶;èÍUB~íØ°úe&;;®Q¹½Ò4{M÷7eO>nÏH~3«¶üÇxÑCÝ¶=M?ÎöèôÈ×³wµ+CzA@ È	4-$\[ètb¬Û·3Æã¿·¼2@ÑùFëê= Ç&.ã3KmE5Îae&éIÂ(P$Ân,Íâ¸r6hxÛöðÙÞ¢yÏ±wâÍÒ$ïR¢Y\Ç_+À&r¾Dº:Ü­Màbµ¼]ï½uñð&¬3~ùõ@qÃm\
Ç{C3óL{Ï´·= =MÀñú1Õ4%÷ûRUôêiÀzyËÊìsãePÜ§EÅ	Ó7­?#ÞêiÂ9Ï¸vÂP|a¡w;}TR?NscQÁø¡fE¶bqäÍKÑM=M§TñKAQØxþC?»µI1îtWr"zÂ@Ì¥¼D*¸VÖ|Úw= ØZªëËJk÷aFýÔñU<æ¡=}²Õ·ÓKw,ü·Åø;ìFN+ÞP9"6 ñçP£È/èÔFîÑ¥¤^HÑ= Ö144ÔhÆ}DB#
= j©îÜu°¾ÐpÆ$yïmtP&àÃq5Wo âÒù]àIóè_æ^SPÊC!¬µÏM°'U\ó3»Ð\C5H,ÌJÇY¨Aþ-ÃE¿UæCjbü'×ß$J¥FÝ
ò=M±3prLåFÿ]ÁoÇyzÑ+®(Ì®tDF«7ûI>³ûVÐÐ+ªI%0CÆ@Sg*kKGjQÇLjhéÒU#hÊu2{'¡F_Ò1	íW7¯ócKgÊSãÿlr)cÀ×Y¯Kp
äbäÀähÛ{?a'rIpÝã¬Ä4{}M l&X¯¦oØRötR6Û¨~;5:p
ãZ-¥Å)ywÐÁ'{èº\Ýá(°÷úR¶¬åÝ(!6£¨_TÛmgx½õ°06ñÜ~÷+¡wfÙEøòûâX5=}Ê.ï&\ÌmIðWA ¸U$ä±ãµ-çê$À%/9*Ç:P:¥nä/÷¨oÔêë© ¾zèO[W®ùòßãîýo_|+èàü)åyÔÌB¡¨Kåz±l<c¥ìñ jª°îËl©««·×:4/E/r= ÐüîÆÆ²iðä¼rWÛì¬}êfÇ[xVc}L¿Uí6aA.q6¹c\,|½¹UÃ'Bò¬ãÙvÓAöD,Ð9ÌÇ=M hÎ+ßNÎ/ÌÄí²jwÇìm½= 0zæw$ÐïF´»Íï­>ãuÀµK©ÿÇ«ds~1u?úW0uÔªg3ÝüáÐcµ/¤ÞéÊJQÂßjÞ sJÖX·ótùp*­À=}K-i¤+Û>,¨2J0feo««6x/J¬~Åâ= tV@>l'Ól,þKIbv§×öc§³pþFÎ^g5¢b{N/Ve{qÅóWÞ¬ÇzËë¾l|KÎG£SyZbÖÌ}Àí_= Ò{Î@ÜÁ<±íªS¤SW¤ÐÅî
¥.ÉGAÝâÅiÜñ­Ô4íÌ0µ\MíÌ09Ý#rØ¿à·9½ä)e5ìHï¸K#
Ý¹v~Æ'óË*y%©Â\Ü	Cv% Û¨4ûzóÄ/q ÀÕ	ª@µC	×z
(c¯uCìß" w¾_!U,Äuéäkp>?ÛÍíjq¥sgÍÔ¯
ræãâ'AÛÖ¢ÖîBvüññYÊ.GW×¿5t¦FS«sQûÇ¹+uÎDö!sS+u4ÏÒnH2Éi¥¼fVª FÑÍ2[I{brÔ©Â×¡Wzôý4}Ó8À¡zh®ÌlÎØÌ;e@ö
¦ëµà¶%å6£§r)½S·æéP1ìæi
4LÄ!p·æé¤!è\Y³1ÑáÖuw¼1-ðù|kq4b:ÒeU^aL+pFò.rR<lÃÃZn³ìLâî½÷èò°¯ÈtKzéMáþ¿ýrêSª!ãï5t[
aÿ$	åé}LØêÍáê½}Í«Í8O*3ôxítROIé*¿ZjqÒâà"9}b}£bm6u>È s¶xÈÛ<þí¸u,ºGÍÙü;!«³W¼NoQ	#+¤æ*6æê®=M.®%z"aÆG"«J¢åïäÓtOY ÁÇ|êÈNïècîZÚ½@Ò/V¸#v¦Ð=M$ñM^MNÜzË§ÅJË'»ÜÅ'k7NOs6^afÚÝIáº£H]ë
-N¤Àé5¡B1\ÜY«)EÈÛC§¶xðÀV¶kÓ0ÈT¶ý_²¼¦YviáÃg­êNÍ¦PÕ	jëOk[È¹#çtXÁ»$ x^= Åã©T.wÛD;òL;.7Ó¯Ðç«¿J¸£<×$ Ý^çïÅyóñïÆ¯é:½=MðÜLÇÎ0%±¹= j©º³·mi0gÃ«zÙ­pq	ë)aÚ[¸5ÒÓéH5Àþ
,m$µüL¬RÈk«n%Ä0ì=M÷¯lôFp½dþo§OÐoL+¨Í±j0x¼i¬»+[@ðm·¨äfêGOâút>þ½pj°'àË8¥I\[¸ÕÕÀYøXÜ+×5Fêý¿ÐDÔ¿´ið2Üÿñ?©!°.øØÅÙp» 6¯Ré#+pdýÙG¶=}âñ}¡qNºcKdn¥×	èjuÇA7¾ßn.ËÛ§uXª÷&Þo¢-d¹ÂÂ l0®kø}ÅB= %0®TóCp0¹~Ç=M= Ø8r-+ËªyXÌÐTvÎ íP[íüb~V5ë	FÎôþâÁg+è:&p¨SÜ­t,àd~çÚ	<d^B/úÃqïÍÕÇ/ ãru¹Òá<¼qö©uæöuþ¨ âÌH©úØ°óè©ldôyx 'ËqVç ~ìg¡ êYdô&ÙL!ò>A¡©°ü¡8úL[8Á/gëºÔÀÀ6|7¡xôºð­ÉQxg±¶g÷#I¨mrà|áUeîo643E¿= _­qà(<ì7 ·,_BÀ ú²ßãx9Py*úä+ÙÍ;ìÄ£]Ya<],DYnº7æ!s%éQè¡MògcuÝ!	çGtSêy¹8´w!ÉIÍ«Å8O
âÍå8sMALØêUÝ8uívÒã32ã^£Ý¨. ÆX9K¤ßvUÈ¬»'çýO]R(e¤ ^J)ËÇ& W,&JÖîf7^ýÿ¬%úý?aRcTÎÊýB?IËý:¥ÐÏÁrË'!»ÜÅINs6Þa6ÚÝ¿ZqG¯¨ù·mkÎzÉ·RcD=MØ§gÖ á ü%ÿÃDz¤CÒ÷-ìã äÙq@WîûWø½]*_G#"T5ù)aø²<®p,À!ê[Ü m\kk[k\¬&nÕînGZó1yãyIô4Þ}1³i:®kÐ]6¶°Ál§hD©'Ê¢­®(ØÍí¯'md$¡©ítí*Ía®°®/¨ú@×uk,î¨-jÏ2n7ªZÓdl:Öµ¨#%IFPü h&>ª3tÞúö×î!zÌd3Û_Úßàø!pd\'ñ{= ÌGwã­¥´Ý= gjÑËË¥!ÝXKÓ#Ô?Ý¦öjÐº3E?já7I~* Ðx$FüõbÐ d=Mä9ÐR¨µ¸­­rêêédrêð !æéËM¤¤·-säiEqºHð&åcÑ&\-~	¨fÔ	<UÎþR-ºxyaÿJ®49Z!ÊK=}= Iµ'e[MN£õÌ
ÈÊAÿã¤U.a)¨Tt9·óCºèuÔó|»PÑÁ(Î_îÊnëEýßºRmº0ºHª]özÞY~~·ÿè¢á_«TõlLD<)ÎËùÐ\ãÇ¥bÿf} dNQ*Ì#_÷V],Åü$d
iH5µÓ¦óµTó¾1>áQîõh,×ó,@¿ú¨3x¬7Êr¡4¦È\®ý²>$&À¥¿ð9v}í2héî/§hP,ò»ì4+¦=Mnø¬ýÕP.¶,mlÀÕåád¡YX(n¼Ò!ô= ¤'ÏÆ¢iêãGÿT[îYCÐ7dûüVÖúó®î]O
.§aïY6ìb¦IP¢ôÄë50©àÞpåx0ºOö­:efìSÉP4½ mVÚ'QPRmHd¼_?	6þ31¸Ð®*/dç8&.#º²Pq~ÎPÔ#AÓh'³h;îjX"JÀ %v6ûâeQHö÷r Ñ"çós¶bHAeùx¶õ%×Ó ça¶øEOrÝÕ¼Ýºt6ø¸Âù¼m²°?@M?<#eEÃä%TJ{Òüôó¡ÊOQ2nûÒ»,Ãè´HßJ#~ sª)Áç¿dB@À²Hò%ùªÜ¶ð¨Rì{KZÒÕï×Qp;9LÓëò¤Ñ¹nµ­(Ñ¥j	×mØÈzZÍV%O-ÝêÄÕ4¤Ú oð¸6É<R$\T|PôEòúÙ ?!äkY6¾ß1.ö§3µ¥uâHo=M(ÎÆðûÄÈ^Ú·LwîtG÷f»ð:äF±%Lh"2ð?[w|¿¯>äs	Df;­/oìË(wXÑ®ÐcTzõ×´³¹CÑ~îH
y»räÚSÿÙø.Y¢d"j2÷ZçôÚùR´ÍÑ±ôX,ÅkÊ;	z9yÙtNÉS;LKïØeç!¼²³=}Û-[´$±Õ¤swGmZï>+¥zL±nÓ_wf|9ð_ßËÁòñ$] Cæ9ªðH>ûÅô§¢
w¸)]4öëY"^§Vói>k ­
[YíÌþ{Ô=M§¯ô9«\;«ÇT	îÖÿ¤rV<aUó.¸@ÀÚ_º¤²­>{©½Í¸uá~Æé28Çô!C0Ü1ð.ÁoHÍ'ÍÒ= YY9Ø	(£k,ûÍòL½)ûñÜ[\²Uéwé¦zQ¦350i6õãs _bæÚk=}Mî{.óK|ìS@öä®IóÀ©shi Æ´E?³ùÔäÝ@aÃb&­É@Ï>vÚ}q¿îMmÊõ¿e
²¾ö.lÏßpêªUL~aïSU89ú.Qê¹ÛnÉhv¡óq9±ÍÉúÓ	$Oàú÷@yBßùH0ÜfóÜº_tµx<tÞ}åBÎG¸ÊÍ7øT#puYù¾=MKù®"³;F
Ë¥ÖB¥aÇûÙQÊ¦-¬éà)ùÔú<ZòC^ÿZOcûÿÏPÌjïÖÄ7&P³.UãqQu%?ÝÁÎ¶õ$±Rü¬öQ^1mbíØzÞGïààÅG»yWIÆWÆðq¼R2¿NÎ)%ï* ¦o®h©¬sH j¦N\+y»#B ö§X[hßX
¾Yh69½£æ§2BçóK]ª{8Þò= 8õ£ÌX²
Û;ÐuÞ­tw@KîÚ³Dmyæo^Æ0Euä_å&VhíÝN{Û»þ#t95TPKi=}²Èk^Aîþ7 
#ÔôÏ ²}ãÉÏ*ISW_ýY<ÏQ¤j½ÿëöWÿ¼_éQAËoÃ>¤ó
7@[þñêð|]Î3±cçkSvòvç=MJBVÛîÓ#jý¤6qÐÀiîò	ôoVÌ×
Bâ|ëS,Æ!æ"Häý6B­_N8¡ëáhU¤c^êB^éÑ ¤*¦gF~´ïN]½ãÕñÊV^ã4õÛÁÛÝ}lv@Væ[_}(~*|	d}zÎè5	:ò_ÄjeÆãäÀv í(Á³v<S¥GXÖº¨c,"½Z= 5dQ9Ê÷AAdý$~=MÇ	Þ»sçI¿
1óæVõü<L8öÍìHàcIg9,³l&Í<O+³ðÐ_ìã:4$©~âàNZéÚ­07+XÞ*_$É·B-¿;f.èXx£:Ù¦XhÞìÚÍÆ:åMÅåÅ­UTÌþøÌ|áJâýxü»½u%ÞàW&ÚvUòÓ*Å|ËÌ¤¼hëD§yÉl´¹æã%Ö9[.ÞìtcÐJý¾ÝÓ¿!á8ÇÄ´ÄrÛ!:ÔgÆ#S×+uUÕwÄ½3´¼Ô= SNÏl'+mL'ëw¸%>ÿ ¤9= ÖÖ úXæÂ_äÖ£M_Xé«@­V@òmÙ/á;csÜd	³|ÍdÉÐV	­Ù¹®E¥¯ÐØtÏ£ù4z|z	ÐËúØD[eA5Ýjm P7<pQûg?8öDð#=}(Éèê{=M= öx=MÇ#õìÆ°£ô¸ÝðÎ.Õù'ÐíÅdLQÝ«8«0Z +é¯A½dU2r= úy ×ôpO§Éèz/âÛ= WnkOÔUÀ®6ú&}ÕCÞÍ}Ì Ù?«ñ«¹awçI2¶ðúJ¥ãüQo÷bÛ¼ÞV7@.oVÑÌ¤dÇ©èÅ04 ³ãÿâëÑIRCÌÄÕi¬âtN´=MÇ%b
o,{èø !ÏÑ¡¯BàbÔA¢ûã+MõIæ F_a	÷s±öÝüâÀUÌhé]1ÐHE@9Ï[1P}ê/Üq52ukë÷YáMEiÓIåäÞ	@¾kë¥Í^¢Ð#åQ°^§ãçÌG+¼ÇÈ¯¦9
P·¤ûÎCÚØ×<_ñîû /qY:£ë}«ò7Ör6³{=M 6PÈ c+Nñ+ejý§lL½%pzØt+¹2dú<@N)R/uÿÔ ÌÔåMõ¯òÛJ®¹n]HEg+À¸ºö%ãÈ¾l-U2	I§Ân9÷acÅíÔi;z}JýUj(9û÷ÆkÊ¡NªuÞ=}îý/J= êÿ:,©¦¡3
èT£!÷öÙ:¤YÝUqdÎ<Ètb&âd#²ÁB5×»üÕº¸ï8{è£½È|jR^ë;Y?ùð#ßZ,Më?ùÂiÎ|-Æ<©[u.o²ï]l*§MÓW=My½*M^ '½=M"U<¶Jqn­Å*ªóªm­<Ô!sê»ÝÌ²äovLÖOçÕgýln¨fPn¼~ë³[RiØÝôp ¬(©ÄÖÉ%GC£Ëb1Ë/@êOi¨¯ð,È¼fÎzÄÖ¸ã®«5]ÐQhðÓàI=}m/lmÙ®¦¿7Õ¾mn®¦ÿÄeøp<vìO¡®¤yM¡G¸4§¿ã¥ì§ß,µ]ØhQe«õ¦ò,ìù¢ù¦'ì
î \ÿßgu¨Øê$ÒÑ&¬ ©ÄîÈ?p.9rm\|= ñ]vÆâ´l¿Û.×â<fvÑ°LAùç¯WYmG×TÓÜ ACÃuÏê.ÈUµe£B.Í«jÆdtc~°A×yÄõôµZ¤9êÈõÉ«[nÿåi°V²jìêìÃ¼¸z :ÃÅÎ¸é-R÷Ù´ZçOµª:ÉWÜbk±Úó\(uèWá0ò¼¿à,¤~èf®ïÕí:Ïr ¹[,úÒaåï/Zô¢HÇËñ.
bs¢F;Ð<4ã: ïi"Êá§}å&Ð÷z?¹Êz7Uæa¦-&nÖ'ÊWuqs¶ýC\= O;Xs×T§Zmîó¹MDìD¬büµ³¸ÖÀ9iz$Ç[l-ü[ºº#Mx$0æÀÇø
U[ÓfYwË¡Ò«)jX·NÉ%£çÞÐ §p¨kp¥Dåü:)CícTáHíêf£·fm7OPÝX= Cº;-«»¢wÿÌïÌ>&v¶{ØÄOVS»ð[¸}]W¾[TòºDéÁ£@1P8FU®µ^d¹½	{õÒHÜN»:Å#ùÒ cY»¨ºïÍoë­-xp¨q<þ¨K)ª£g¨êÔpÐôÊøÞE©´,½± æµp ÔM:ihÔ¿r9ì2éÃª;,ÈiÄ=}ì:é>8=}[­eY¡¸ñ³¿84"ó«]?'§ÿÃ'àV;_|Ø§ÿkÊ¬¿k»×Û]%2vó\OêrÄâµíÌ¹gsÓµNj²'ÐùÇÌcv3å´84qis·ãºÐ×T8*ÜÝyó= vsss U= *ÁÈwÞ=}'ijÄ§\ãw¹ùX|DltK;.4ÉÏ,ø§¡xp²½ÐÝxÜkõJL[[NÁ['k7&uê¦fç#$ªãúÃI&WÎ@)¨ùÈx(ÖAíÈÐ5Ò8f£2sÖH¦ÒÒyÏ|cQ*¨-_ôèIï{¾¿jÖ= Ó¹/ÆÈ%û åàZb$Áq¤¤qPìÐ1Rm3QË¿£v,¨»,¨Þ{#
®E=Mé£/Î*p?m(^yq,/N(6)oìcómVA(]ÚJÐ.j¡_^H¼ ÛÆ.j¹ìP7ÈPðêoN±.= nNnÄr hÄ¤îÏr¢9´o" ÷Í3LÏiøt¶à-,/S6_à)Çjõ'#~ìõ(w¬$5rÎØnPñÓ 4ÂGØóUôÖ1ëºYÍÿUônÿ·Ù¸ Ë¡í¸©óW|u¢Â-µ+T÷ï3µêÂi>2Y¸qÀÆ6[bK¾£
:Âü¥¿Ä#´'vGgcÌÈô^aå×ª£abÈÎ Í·»Þ*1û5Åÿ·zÓ÷o ì½×!eÅ·{ùT xp²ÖËÅ1¦þ&£3Gø_~]
´FÈ]fi HùÛ½ÀNHºAéð:<VdñÝø¿
}ì?½º2©Í¨E½-Q¿HS![
¬=}q¢wÊÕ¹(NPkdñØuÒ²(!®sÏ¤;á¥ªûh|G5)</%ÍfÍxÞ=MÎagèpúEºÃ®ÍÜ òÙtÏ$V,)-â:3PAÎvÎ»´! +A«6Îèx¼$i3æµ]Ý¢?Ö_gÊò$gñyúð"¹½IØ1öÓ**>iIØÞi:£wý3Óû;½|]o¶	ÚÓZÆ*ù
Ò&iÙân"¶STS+ÞXàÑLa«¡XTl¦ùz[õóì9ÿÐX¢ô9á{!ù$5ÅØ5BËMGôÝQuqiÝrÒFS%óÊzTD¢!²h ÐxÆ;%2ÎAo©«ëÃVõ&uäZþºHq§Y=}}ÞbÕ¾¯0tmÝ1ÐÁ©ûÆÂ¹Sö¿UýÄo LkÕ*«¨7?@¨Üïíý\ß?Ö $GqäñËym­<IEz$ÌgRîqWüædÄØrÁ¦)~ùaæ¹9Cõôð_óö'AÙ,%óäRôÞKõF¶;P'ä¢kÌóYÖßh^DR&cb|ÞvPruÇJV+³RBN?·-ë³Yý+j=M3Ø¶ú[´FMº¡"ì¼¡]STA%ê=MÙýÒâ= çª	·=M:@LLÏtàß¶=M(àÀ²$U¾ïFuÂü­~¦õåÊåómj]Çûeü\sã0|Òla^q70Ó#Céýytw~ã+ÖH½ï^cs­E©aH@ Z¨*ÿëìgïöÄ¸]P].¼D# j~n
ªôàÏ÷Zã)©Ï¤Q?öÁsVË;M¾Aÿ
ôTÿAôXeÙ¤¹²ýç^aÐ(A]saý?Ãdº¨¥Îü|}+Ð_,0SàÜmîÎ¸¼ø-Í¦_uÃÊ«Äh$*(´DQ+ t@öaº¬M!üÍ];ÚBlÔÉ»^B}-ú¼PÙÝÇÐfb1¦¯á-­ph@ìÉïÿË­gûÄàë9ú®ïrXú!:
¦É¢[ïðÀ=}å"pøÎ
i,{= ­ß~·$*óÎ×ÇNÚÞv= 8inÇÅû5Ï%ã±Òm.løRWÏ÷y«þ´7FèåX:Ý©VCB&ËåM?ð¸-¬EøË²)0_Áåþ^ÊNñ»fpa|m«ÄH ù3Q+qíþØ·Xû= »M
!ÿ
LÖ¡Ò´pÔË_?íQ"^é	hy	Ð]jFT]pZ_+^0b.MuUÉ²åÔbáµQ= ?×óßþGÎË=}Ì.?Ùô¥øûvh^|;ïáó4sJyÿVcJÚdKé=M/4øëíghï¬M\o§"·_«UÞ[Y+ká]ÄÀ	×<þvf1=}³ýaþÎ°:ÇÓ¦.Çl'¦¿µA
.ÉM"iÇ¿Y*\FôPÖ[äJ¼¬wÏGª1LM4m¨\#£Î>;+x¹>ú¸ichÑcÜY¬RJÔg]÷Ëè=MEcÕ$n­Ük­÷àÝk¶$zU÷àLT¶à¸HÄ¬ô!ÍS±ÍÌýl¸pÃ¯{¸êÑ±:_kHW¿*²¶Oág¸H¸­#uçX6¾HjvÕ{øÖºCØ\±(®ãËc@@o¥x^Mië4ØÖ¾Éäú%åÖ?ckÌ4iÍZ ©áüÿbP½Õ¦n	¶î[ÅÙcaÉ#e+¾ø~N¨è&5iÛ¨Ë¯÷¾àÁîhIõ@D¶}_¢F[mùäÌÐ"(÷Ç÷ÅôFÔx½õé+=}5]+ù.>Ò$ºª¹nþb×eý] f	$ ,sOE^À?YÞ Å±¨1»¥îCËâui+}V´Çèø.
ëò´nø|æ'Ønë\èlbôä4µ:»Ea@U{¢êPª3^óålÕÄ:÷9òV¥3Å¤ºß/ZÈ>Î®á.Ôçaï<Ìxäë_§¬óëCÚ¾ØQuûÙù[W8pRwý2 {Ûûí¹ÏúÔ£Ô8¥6;ûÌ$_ÓñtÆ¡^Kùh|Â$}"õHÍ2±]$ÂÈéôäJaõöèÛ|y÷Ï£>ÛÓ&f}Èa}M¯²|OaÕ éÀïÒî½_ÄÓ.ÓÛã³ÆwÊ=M.=}Ji(~·î_aÕr(vÃzÿÜÃt·Åø´.X·þÔÕYl¨ÝLä$£ê @WÉélÉÀ
(çýþÐ= À"-¨dT+Ð´BfA9= Gxgm´'i§ÏË¯y@uÿ|Ü%ð¦éÐÿûã	2þmñ×¸ÛÓÿ#ëùSãö ¤S>\óNð¿%iVÓÕ,·[°U­óÍ¼H¤ÁNÆ:Ð?/xãÓ´B¾4w±ØAK¼ñöÆ<«|M­8­òÃh KÜ´ºCÅS[vù ÞáMhñ7$ó¨W@U|Mfâ_	@z<Þñ±fn¾ó§üûÐvBÛðxkÌÔCln)ÏþÈ\¤JµÞJÔG¾±TU=MsÅªárUCV#)'D ¼+6¥F5ÏSq&G¸5rCgAö«e /ñ{ë92Ýõðäh¾û"A/¸KQN©¥zA5 gv^ä ñZ>¦NYÂ B!= âÉ§þ¸Þ¶hÊýe= _!VÒf{RªY"ù6ß°³ ÓÞv-2WÞt>{C
*¼Øï?µ=}±&²7wÏE£$üð¹8u^Õ×°#ýù>Òà?vxTXSWy¿â¶;ZÞ|¥
  ~~!ûáË«QTE«¢wq#_:Ë*ïQ4·ÅÜü^¥Ä\NæÆéÎGï0|ZR&=}ÔÍdQ_ÏØf.x]éóLgx{'/ÂÕcÅÔoò(
z:¨~¤XëyíM|Õ/
=M>ßJØNO¯ç Ï  oî¿%ÎÎ á¾#= x>=Mí9Ný3oþGÚv6¿cvÁ´E^kÇb^«ÏLkÆ		Åás#½Ú= fngç^?HjO}ZÃ/ýgßOxþªËÊ;%©}&gÔ4éµòÑ#Fç5Ú÷(&è%H«Ë M2v²å´ÔöLÃ6¡©Î©t 6ÆsPt6;¡°Í®,]l!ªÉ½[^.-Ä@¡Ã°,3v­uìÅ­?Ï5RY·$.­÷)Qá
a¼Úh\é³<Ë¢@{ì¦´/ÒËìN´¹nÏ¬ïüOYÏáá_o{ÐToôä &ØPlQ¥v 8hþ=M*h&Õ÷zkHZ[bõw£ÁrÖhQÚhÀff÷ÏxÊjÇçt< _è£VÄo¯¬¬m¼RF¬÷þqX[i=}L!P+)oI-Ä· þÿ¬Úøe¸ø@BjÄK½24§TÃ{ûÝ\ZÜ£ uÚvÚ?Ô¹Ç´À"Á*½Õg]Cþ¥?Üj,ìÊÎd
ÁAÜrTºÓ&è1#a÷6	ÚïT¦×Ë<E¾©ÜæØ$zÀtñÇ ~®G2j\ýãFÓaÀ-«jÖ¯ÉöqîM IF¨¬÷Æ8ÐXIÎ=}Î§±&B@ðÒÛáþaÉÃc¤^Vq©cõeMn± v= w7_&Îäsãú#WèK?8åÃ;\õ}ïSì#kÿøÀþÌÌÈÆ= êxæÄqÓøy&§K:¬$OÐ@2À(kª¾¶F|®§ÇëféÈNl'b¡ÿÌøAëº2ù¤<y+p,y%Ú*´__­Bt{BNùì¥¡î$]Ïc¦£"L_¼Ý¼Ô×òð°j3»@+aÇ9ß>t~ÐÍæã0¦Åå¼5À¢è+l0vÒ¦ùNÑ&EHHîÑ=MÆ_M>öû¦ó~éwS¨>[ÌvzJöµ­IÐÊ]lSÒÞ¦Ý0So>C°ô¿5á;WÿF·ÜaâØé:ØñêðÞgY¾ÆJS®_eõl+5JN*[ÿHåoÄ¥^¬ªÚ\IÐ«Yù"AVaE°D=M?²´¥ Î0³øè·râö5e®ÀPççb0BL»C/ßî½#ücíÄPsv=Mv!Åë[:MJ2wcU6ûß(¨ÜfYwùnREÿÅ±O¨¨Ö=MIæÈ6rD¹ÿÛøÉÁHÚþ¾¢È"_ÑYyéåSD
õ\;1êð.æÄ¹kbB>RÌåÚ_0®7ÎÐeaï^Å©1ÅO¤Yb¿QK°®uÎé©¢ùj¸x^Äl@NÍízcx ÔDr6Ñõöè* øPÀ*ÏO÷1ÿØß3N8Ó;ÁÃNËð¹ûà$ðé©á§r3¾¢çNx¯¦
a¤ÙP¡yB~G7è4*0jPµEã Á[w° l¨uLÀ¯¿£Åv\ ·ð÷bw\%>TRÜ£ç¹ÊðD!o>ÙSða\,u»Ù¦1ú´ä©4:¦¸Á|ÖÝï)GOöÒAvü*oRyqIv$È×Ê{[:{ÎvªAÞë·6÷ytï6_ÀêµôC©±¾¼r¡×MøÝWaîÙbn¸pI­>ÑªñÚ&^*é\ì=}FÍ¦·_le7VÜá(nCmÜxûGÛ	áüTnk¦af>£bÔÀi)¤$9Ì7ÙÉeMZ¦'Ñ7oÍ
g/A\Ô¿D>rWgj>ð@xE³è¦¤,F©ÍGì@Ëõ°SKX-TáÀ AnÍÇ¤mguO¸mºëuî¬Ì§Ú!
I  À1&Í,È3ÌïÜí\Ç!m.T;£Ï!ó²Ø=MñÇºÜ×M<1nñÚ¹Ð)ødë-Ë&Y¯Å\i¨ÙíR¸ËK©"¢P«ÅôÍ= 2¯µÖR^ÏÒõÓ´AM°ùz|b'9lGÜÌe»§O[øÙÑFÍþ»Ë5ÌBh¯S³ò&N =M¸³D¥>Ïÿ««3¢çËÞ5|O96}«=MQ¢6«·Ò"gLoò}5qeýÛgeúh©cAïTû'¢;,Ú=M= ,ÿl¸2nÇÎßnòtp£BnÕEÞÄúxÛï¢Âktþ'4ÞbE'¼ï+y1ì07mT7¹n,ÇËGõ
è,÷
BEKÙD+Mð ch£²õÑXôuºûÙzJÜ]Zì-ÄoæüÝW¸û³íµNñq 2EJë_uÆcflòß´t±¶í¹\´µÅ2ÁÖëÂ(Èþ[}-\¹H=}øÑ¡·uù!·¾øYwÅáA%,= (:½gi¨|Ù7~6Õ	çæüLB[Ý¸QÈkh©v|qkÍf¬ñØÛõ-¥§ïÁ{¤iDÈrUÎq*Yí³¨ÔÈSsTd.	âè4&ygS7@÷Q¡9A|';¢(®m	½ad­]­ÐËý,ãÌYëÃèYh!Âk¡×íæ¹sàéë/kûÈì%ÀÀHX´ZÒÇySYur¡ô-Åø Ø©PV@úÞèQv[ÓÍÆ/¸Ã>
|õ'o+¯]ÆØc_ÇãïgA-¤1Q2m¤F
ü'o«-,ÍV]~®(-átéVÔ3Cm^ÔðãÉÄ¬ËêõøtåG"{HØHnT¥ZúF±ÝWI_¥G)rë]WSÕå:ÅGÑ>È^ÞT½%/iÖ?½¿(ìß?QBêËã³ä*ãDÿOénÁB³o§¢öå<hKÅQüuñéøéøã¿!ÎsP7dkðü~qßzfà¼|Ï)UØJO7ãÐ~·æ(mmAYihhÝÜÚ²otÕîËâec§Ïè+_3¦pÑ
AÃq¬÷<¼:»¥êÓJÂÈ¾2ìâº{êÎgÅ5= ÍäÞÑ)É:1úä²wë±3ÞþcÑûÔ\­Ålÿìº®é Ë@òV'®EÇfü­f!JMÏ! S-T÷e¨Z£kQüÖ©IQ£_>$:°*ú$v'Ç|ILv¨ðÅhDXTä¢øqÕ7öíeH¢;DCÐ°¯= ¢ÈQ«x*¯f<cën¨8°_p÷IÈòktÖâÙðYÎðzUÜ[D§UÌÊD¬,ÄXÞ©?ã0* &«=MF°&§MµSëU«4ËÔUEÁý ÃùÓ_Î_|îvíùGc# ðK¶"¹G,ÝfAå'ú¡ò$Yu@P°¾KÔÒ¦×)ý²Í Yl{àFdBþ#¼ ôm6	F_CIÿÎ[À¨Ø¯ÔµÏPëïwOsòãÎH9£x7Ôj¹*­ [ç'xLL>!Sb\T$mAlÂ*0¹¢Ù0x+³±]Ïâ´^~fòVPÙ¼ú¨Àá1Ãæ<
NcY]$ØÙwTþZd= S%N®G(Àh4/,WdÀØÕ(à£S-,_d/Èò¹=}¿_d "N®y&§
ìSR»hß =MÌX©çÅ¨vËÍÅçV{wÞÅ/»S|%^ÔÀ@]ÿgLû±xtì¾¿0;lþeÕ	sÍH"AÕ¶ª>÷´×À¶R¼Â0ëÎwZQ+ìÇ¬eµÄYÏ~ZÏ2ee @@ñ¦uZO=Mù¦ÓÈ\øKeàQ+xZ«Që[u³)¨­6K5nR)í;ñ-oÐÈøv=M­$è·ï&ËÇ:ÏÌÇê6ð'ÐAE9!ÄÓíy ù,ýb(r¥BÑ]&KñvÈl"/×+7 z¤Ý°|&d×~?>=M¤H%£ØÏpéqµ²ã8§#ufw4¾99ÚäþaR&v"ì	úÀ7"¶ªt¨ÏJG¼áëx¼¿ÉTBQÉÚe:3ÀÑ_Z]ûFmùîð'åQRìµøüh|A­!	+OÄ.Oo }ËðåëM>$ÍÏ6Ó,¤ÆKÓ: = ±Éý2!ÇÇº^n
_K	µ]¸Kk¯¦ ìcMn¦	Ó4·oe+§ßn?O°{ë³¦=MÆIAÌ\¨TN>Þ*Ï¶ý}"{PDIU*Jx¸[ÅÐU¯4:1äbækÉ£wÄÂÓ¿ç*Y òÎÛVWÄ·zÚÈ¿ÇRÐò[Iy 
}v-w_R¶na}È¦zô8;yêøù|ðÝLx£ÑÐÿúùÌê	6±@Õm}ñhXCQyp¨FçÏ2Ó
u ôÔõàN·µõX}½:Ùv¬emÚZ=}bS$Éé&XRI!æÀ q)M5¹|G¼	bzEÿ
}»øþ¿&*Qe}Rþí%d½Ê,6Oÿ¤Îïcù1ÊCí¡:æÀEø¸µËóÓU)wÓíJEè:¥ZDþ= »fô6Uõ*¼TüRãVÆý,âw^)7ÄmÍ¶ÅÇä^Cv4$86þ6³CjBÊ¸ç¹µNPm©Ù^Äªþ ¬ÁñjB$oÉ«ì@¢LmÅ´°üüó­óÑ{°Ñ©C6i¯ó=MónÆÅ-e ¶Î­ÁùN[NàùÌ.ùø!ÅµÌT5ÄåY$³@¦Ýt~\z7èMc}Æðd£ÌùûõT²V=MÑ÷­ús!4°?7I~æiMåí"ã/#È&ùQLWy8qk¥àAL\ýõ ·»»îé6ÏþZE¾¢¨¸^·ñò%*[E ¶\XØØ¥À®éG¼5þ)N£Fà/	²xqÀ P ¶Iô
Ù®ÐpgÚMÿFn]¬ó­À­dY²AÁÜußN±ÁÀ0­ý¤K?Ëak	VÈr[ËÅãg×jzCØE6¾f¨~'+èIû;5ù;¹T1æ8ÂXânRNËJYuØ´¼¼ø«{FíÅpfØNíþíû#jáâääjVªp+U¸égßjFwæ¹#:â.,ßÄ+ªE®YE²o¢8wÐâUVRÖ­ï×bgC¨Cq6[ÒµP¸ÊUIxà@ãpXWÓÈÿë:*8úÐ/5 (õôK= ¯·Ë1:b_«¹×(]imá -®àhØ^¿ÐjrP¾,Y¨oð^7î<i>$ÇÊ«ª£.b1iõLÆ«®sÝHsXî´:ó²m¹· º_îá8TÍ®ÌíÑeÔÌ2+,°È[¨C§ã%à'ï¨ ¯!ð/®%tªkP)n3ð¯3ÒL¨ÒÒ]¼MÔÿ%t,±_£¨RU!l¢ó" 0oïg30j°+kÏ+à®¬úÙn)3ÐTÅ_ÎHç5aÛ6&û÷]3ë\ß»EÃòKónxmªªgÝ;Þ»?>HOõ¤|ÀÉH¹>1½VçÞ«"é±£ÑïüsÝbÃäX]Y@ÔúºhÚãÉí´Ëøí2TÏq°Hp9DÄ·öÄñð°Ã"m«&°ÞK³·äÁÌý"I1çsêöW°\£Ü í¸}±Æþæy¥©Ñê1}9Âf«ÊkÏ&ÀïÖ!ÁvRäò[±ÁüÞA³Í,cNX7¢UYÍúÏÉù	¤âZHÔTi²ckJ¤Á=M(jipËúS:r1Ë­âq{´1Î¢)ÆÄÞâõ°Ûma
×ôeNÒâucfÈÊSnyÁë\F;?TU2ÂdcoÐò@Þ[dÉö3
"= ña,HòØÛ¤I ÞlÇñj^{ÿÇÜÐâ-©äYÙ'¼ÇÃ¥ÛT¬:Ë¯9ù2òbô*õZþEAÇÍZ§6ù"êoFü8ë/EwÙ8Ð_X\	zxÒ
È¹·0äV¨z²ñªjÕBJ³cnÐr±ÞÕÉ5¹ÄQfhX{^AñèiZy¦2×wK=MÛ| _G5cÞ~:*ÞÂ^o¦Jø"/ÚM^ÿ5DQ	Ý¶ê²xM)ozÿ Ý¤ÂÎÿhC'Zï9³ÕßYn<%Ë fUmf1{{CI¦)
 ¡\å$@Wàâë©©ZÛÇxwA,l;ÖCÄOXp¥©çÿ+ÆZ·âë³ðÄ!üúà#ô¤DÜ=M½Ùßdó5rå}¯É¯¥¢´´f*|.mdcoN3À¾¼´;t{"ï¸<¡4Ç& düøþÈêW|+ýSÎ§îkmH2ó9©Â8=}iéíõÐ½p­fAÄ	Xö¼½íR¦OÑexÖ%Õµdº5¶äÃmööOó|¦#ÎænÀÿÞ#î#"!;â>jZ§rd}_Îc|-Alál3bâì¿¤ó¼½.ÇTºß^Õ«5oÚ¶ êJÛ	= où ¨¤Ò¢Ü3f4~H_ûúKJìbI$ÓÞ:^6êÂulê]æ´bItP¥M&A°cÍlÈPÈfÀ¾­Î"înØoV¦¢ñ<-»ßc0Ñ;­±h= NNk2 i@ÐWoO¤dâ*¼Äµ§;hXÄÞ!	]Ûåg]>©ÚJzÍ@Y5î:fCF'Cf°?1Og¿¦F6úW©ÌNi°%$?Ì+-ÀOËÈ1vá^aÄ6Á®aq×ùLÃîì^a¿Wåç½ï=}­Æ\p6ë0ç^V:Õpð¤"/¯J v+à} Ìz[«/¨SÑ![»ôãï¿À¡á]zjd^
WMh¿P#G ÀC5f$vÍæÏgowä1T¢]«l÷&QçýòG¦¼ê"²Ã^´J4;±DÎÝ7HÊ±Æë¬7Fç(eI±]cAàH=}÷	3aÕ5ºÞ×Å³Çº¸[¦2'r¾åónÌà_§ÈRÆ¾3~â§Ü/·!Î Lçf5£@/7®¿v3](AaDNNÝ'Ãk Å1È
íëVSx«Ób^cøaT{ÒËêXpZQPÅ"wþ£CûÀ;Lp#ù¼/»!©b7¡ù>úµ*^l^Ý¶ÈO´h²o¡pt²òn´º=}G^&Æ=MÜL:ý¬Æäüãã¶" ¯s6ê>Q#],ÇÛ8ÅÉôgÂ"W IBQ¼áx@x"+×*¦ó4HÚ= ÇÆ' ¯= Ññä©Û¤|ÿ(ÃQrlÞ%DDT¶«×ååü$Ãs/½Pdx_ùZÄ¿aËÝ'NëôVë»ü
õ>µË.ñÅ£µõM}'[ç«w4¢YOòì 0DÉHì""¹d_ÌMÛ	èñQþ±PiÓ¢×q&QZaCPU¬Ìÿo¼ [k(~ð¯Ðh}cUtè¦h/ß¦×m©ÍAèZø¡dÍ=}b èBà7Ñ?»Ù#P²%±áãµ hÃ49§ÑJ",Êã¶4?ÂhH"ÖÉh2¢û"Aþª#¶¾Ú©±[L>Ä
(BåôÒâ]Üÿ¿êkNÔjíøCÉß¼ÖdÝµ	«c;
>b+/'¬}ÙÏV=MyãG
GÝ|ÆùÓÌj1åÆòë|ö6}K¤Íi§+!FO
òü 0î=MÃòl¢¡í.)Ìztk®R %ÌrÕ:FË{VäÞNÒ¦"Þæ ]VG²méËvù¶ìAðÎ3úõ=MÞe®B	ÔÅ:ÐSHÒË{ÀÎÕÄ>¤öùÝóßó»ÎbbÛÇþ&ã-Wyk¨¶¤]B\Ö{Àâ#¼»+êÎGbÐ\ë	,ÏÏsT{¢¢|¢«J® \a[X«ÜvÍø2MNøÈíhòÏ8=}?Ð¥"ajÒssÓ¾ÓUÒÌüDy9®7éRÑ	ch4]HØ?õoÏ£àHUÅáíÝ¬"0Í¤®WéØ6öÑ;Qj¨l0ÉÐð vtÝÂN·ëvÏ£U<au²(y$vSR¨£$n"çç²$«¦9øIà)=}û²FZ¯>Í$é3\ Ôï +?ø¾1ÐÂémæÍ6(	&z]Â+c¾xÿ .Ü q8@U«xÊÇ¬I	ýÜìdð~MA=M¶ü#µÿß÷c4]áÍN^¨T}i Pë²Mi°.JÄQ,d0²!L·²~Êoëßï¸çµxË¨îçªãä tbþ¦ûónÍ°IÂÕ&Ý^>²½.·ªDèùZhÌì¡Ig)ï= QNëÔYÊ¨ÜtYZ×uòMOOxZ"
ûÁ1Ü	)7W#FæC=M²qæ²¿É$j 8s­&V¾n»18üXøsçÙæs5^ëgJ¡ 'gÎc\ò<Î)rìÉ«²q'AÈ×{m»ì}mf?LÙñboEyÃgøUTIÚHBÜ}ñgÈznN	lµ joPð¦Åçñ>´ÛQÚ·µ	´ßgMZ~]^$X7£:è	S7endÚþbºðUÑêbð!aK¦gè¤² ´&g_Õ åwzmÞS wvòä)çL²íNÛ¢*4mq6U2ºðuh»âÌ{´°F­·nO8h¸^á¹^w#·^
¼Å/Íd³´M¥jË³¾èÑ®,Ó"Î,¼uÿ19¾@ñ«}ï¨²r¿)dþÍiØOÎ¸?{K/X´7Îø~9Ä'¦³Æ¥¥µêGRHF|*à|lµnWÎ§1nC±d?'J¨ïË= ºa+Ðn¿a\òÌµ²Pâè«%¦Âb±¡×½ºô°Ì_TlR_bpaÔ'Tn·OôÉütoÀý"A=M¸/t¶ñ¯#ìõá¨ï\]÷gÙd*ÎE¿-1q8+l6«Û²,èp3f¿í&V2¿ÒóYå^//Eg@Í²Z|÷;-EÎÜ"¶»¶?Eü7=MßÊÀ+
ÚðZ&©å½<æàmè!x©eÆé6IlÖ¨¡!¾ Yk_Þ*aëg¦»üãçJ·ßþiÉ|eo½»(ß¯R2 i$ ¯$Ü¨K¶	o~ÙÊCð4P|
îKn¥ú§á©1¿sìÑ÷À"Úö¦¼ðá¼pWüjzóÖÓÌ}íàMøq Î" adv¹lYÁ'@Oxz­òË±otc'|"8»Ýç\ÿÔõwæëegIMwJÌ¤¿Ó2MvPGeÑõ>cÂø= bÌ]5·ï¿cTÃjîÂMÌ÷9ëVTËu&/	(IÐnÊ«á +¢cYéÄÔî=}ÕÚ¢ø[Rö+ÓAÀvlFÛ4PD*O[(BL¢Ç»_üû×¿GÅÈõÍÝ:"«úÒû4&ÍO[,AëÁµKÍ± û1ád­û¥Aü2o*A±qóH@\ã/Õ3UÈ42®´kcZýl¾1Ýz@w ÏUO¢©_&r	!Ã= pÐÿ±ùßIwÒ+ýöt_A×dßs¯qÐv>pÍ
@*¦^ÀèikÄN&*]ÒagÕëwçÈF2¦<!ùV-z»vËCWM¼Ób½0 Ä'GÓ\oÝhTWÆSñL=MËxÏÏªò	VÏÃú¯<ÅÂ£w /UCÞö~üÂA%ULaJ4
a¢uqSÛÝâ>!¦¨Uf)ÐºúíÃ= ?Aº¬=}Ì
xaPÒë¢âØ¹ïòdÈ¾é$AíÿÆv= *\QÕ	öãÈW)E])= /âZ¡Þ[)÷3$fùP9Éb9B	u	#>ÞôxãA{®ÿñwEm(\ß Hôh¥³²lõøYâûãP1ö= ËSö'++)¼']ü	BºÔ´8ëOÄÿê96ólÛö1¦	C{Ç{±ÚÖ×*{ã47v;Sß"N¤PBM$c4ºë¢?ö+¥8-Õù°¢ó$}æ¶CÀJhÇã PPêQãzÖï~xê{è¼_l»iÛGÍÌkÚHøÐWÉëØ%Ø9úXä= ×jè8hè¨§lhûxÚl5ÐZ"«|	ë§ç|ZìÚátá¾W½uüâ¿gå JË:ïùcÃá¯äßó~kP+H1ÿáðBû"°ýJ©ý)IÕTó ä6/¯Úãì÷&Ìú=M +Ç6$ÿÈÂÓÏm0Á ú[ÖÐ¦v2$?î	Ä,}DkÝ;D¢h®c©ÐM,§ôFG´Ü¥¥8{â¹ÐÐg­øOjc= ZoÀ¸T&ï¯= °éîï«>s	Ùè"_E'ñ»Át­¸jK@ÓÿÐ^jxfÑ xyë:G6Ù})ü¿¿3lµA·x±bq0i3_i&XðÞ<=}:PJ<4NKÔ²´Ðß\yÖ$Éî»!&TÀeyÉÒÞoÚ=MX©¾VáÎðôJÓYd°¹3:ït,S= ¯ùî4 ¤R(zÝÏVoË¶³m©8¸mÎorÖ£ô>Ïõ>.?Ëùô[ºfIyêõ»·°ö"nIÖa;v¶&96ªÃz'Di4ÓÓþ­Õ©uÀNj,²D½ð{ö¸ÑÈiiYÕyü¹eÓl;¦<µ|¹áv®çª= ¦X b= gÖ=M]\ízoamyXåæÁ¶,+*á9-÷Õ/}(NsM),òjvGºD_ÚàcéãBJÐ½ O¯ºh·>duùMçzÂîë>êÆÃìú(ÄÈu³J#¢6>©ãY@!¬;5×ojÓb)Üê _ÁgþñC@:	êÊÒ0B¯	/W°\Ü½Ô~ýDÃ÷XlØ+q½î¹c°ÜFTº^zçJLtl-EBQÙ~GóÕqñn:Q+u\¨ %#­lçrêÓ>¯ª$= µØ^¹ÍF~7¢NDÐïø×kUi&¢¨2¼Þ¾KÒ¼¢f<O Z¤Ê¯+M7ÈÇOq#çó£^4÷ëK²dèÌ<[&osLpH7Ø:OÆyUDéÑó¸ì2^ þÁDôã@. Ôxø;8Åp@aä}ÌÆ}ï0¿%JRcìô]¢X*êSÊèT¾ù*7m½ìbô0ÉÙ0.Cpø©$D+~²­²Éî"®bû§êúpÈ^ÃÎ°R Ikô°(= =}0¼£#É
¹óÆÔRÅKõf÷¡TÄ/ï¯kãÀÚÖ¥CRº²¥>j3ç1d;Ì5±Ý"Q¬:{×r!9UbÆhÄ?P= Õþ­¬]$_ÊÀ=}gwü \òóÖÏ\ðÑTò*Ñ£ü?©²éx4Xq¹ßóXª×´ãT=Mi]ceN¬v
õÂ%Ö}'
dÿ	d²PCép5XðþË3Ö#d«	hY{5êåm^øB@6×ÒØ¦xV$ïý3Pï2¿xµkUºEÚ²ôxÆ(¢|}±#Ûçd3{TvÅ®§ª²8KÈý¢l5eð>=M³jØÖ£´?®NÒÈ:]i<EÆ7FíÊ= Ca
bJÓ¦Ç@5¿äË_ñ®jÀË#Â^Ï *DL@mùeoÒ+­Ò[´Ö£Âàà!Á×ÍßDêDó0ç\[Mê­C­¯3Ü­¯M¶pðÃpàJÏ	zéôC*iVè{¬nÜ+ÝéSHK-Ï}T<×kð@Jø= åí+Ïn¬Òi¢Ä¤ø4°X0­ ï7"yµ3X×dªíFÉÔnSb³Ìôð®¿@gkfCWôPÜ¾!áKöopS%Ø»OPÀ¼?ßÓL(P¾Þ¸Ify3]8l/ èý	Í[!ê0Ê³{ÿ¨ª[¿Çå·}W5=}{+DX
Pk¶Î/¿Þ/_\+­Í^ã/õþø[îkZ\3ÐçìïHô/§|­L­Ô/§Ì­]­]¬ªÚ\´qQé5PÛ×YAFDr"qÚ¨ºwküY®¾VÅýw&µÏmÏé1Ø;Ix)=M@rÔµ¨í)åü#ií½÷!|4Hú]A"¼½Éldymº=M"$__ë+n²sÁeH¶¹¾;¤Â²þ,<)¢òÕ÷¸î= ÿy\ÊÝ·
ÕWc°Ñ#È¸äÇBtè;qÔìºB[¨/¸îGÎÞ4âª ±±4G©ë	¹Y6¨!ød÷Ôõò<ÝSÂ¾>9uHL¶1W(ï{ÄcÛ¼Lzw7|Y»\¶÷HMD^Â.]s(ÐÝgÐ¤òåígL»F´P*4?ÀKÙØ/o¶¤EhÎ;<ôÙv<åÃÙ¼#.k ól>gjÀÌ¿|ßÉÉÑaê<~ÕåI)Ü01üÌÈ2½öxþ$(²GPÌ¨gÁ$¥9#µf= ?ïqV<B>§_¶]Â¶ÃN_Õbê/;ê(*å|<jfwðû9>ð¤|ñî7dP n*÷ü¯Â¿v>±9bà"úôÍ.ëzÇMpÄGØ­$MH9Óæ=UÐP8ÎÇÜ°¯äþ9âvî/@rU(²×q4å<þ\ã"NõFq= :I×e"9t»P©¿sr&zoÖwZP@F=MØ|ï9ÀÑpPÍèÒÙ¢ä{ç:øÕÃêäÛ= AÀ º9|geî#ðÀ­§¶pnÐà3¢[(Q02öSN/r{ûY.Ûi9¬<Úy @Ìæ¯«õùup°+6=}Ü¼©Vâ;îGhY¯ÚÑè¾ïùGl°ÄC=}  àqõ}Ñ +ÙáÑMý7r¹nÇ$êÚ .JàLå»ÉD
ý­1x´ ®ÕÂê0)NË^Vÿ¢íXjRóø¤e²¶º(~<³¤b1G¿íD)M$üÌÀ­Îj= ¶W2I*&X	4õ[:Àd·®°À¢¢IµV/µxJÒ£NDkÖ;$ÄtX­®= ^y:õPæÞf©æ$­Bâoè÷àÒùkw=MuâæÄî ÞgÎZ4±5ääÜ;9kÜÖÊoà= !!ó3+vÌ÷@Jâ!­¨8dÁÿ
¤¢°pú= neßDV÷}v}È¯åÃÕcÅ60w*BaSûÖeàsé¢«ÊR¡ì³³=}gEøÞSÏ¬qhø/C¦²Í-=}kú¾ülhµ,"ü?t]	Ô>æ¤= J!_,\mëx_iâG:)ªI<%¡@>ðjÜtîxâ-¬åÌê	Â÷z4ÞQÏb³¡nJò*ÒÄIÊ·úÄ¸V^ðæ°hØäÍàÃáRúE*-Ì±ð¢ÊÇ± ÐAYVb<U+¯ÝÆñL%¼ò0ìU\èµ9q( å)K¿màKáöSëðÿÙSy+úóå(õäçöÂ³ÃA6A³m,ód1À¡Ê×tüöçÖcüUyÎPy+J¯uþÙÈßUà»êòLPÃVÛÚàrÓPÿQ= ÃÜÃ0§)y:È:> ºbýHjõgÞr^ìø'¨Ç}:UyÎ/¾3/UX70û°äÞ· C/ðÐ+/Þ\åçNWLÇ/4mùÀ¤¦Õó\Æ\7Õâ_æ×û¤d= ìÊ·Ú},-È²ëgÍ3àe*Ý=}Ç¶¤$QëñÅ¿8n³Ç{³ö=}(|XØ¡ÉÖ»MX×ôÜ%h]Kvd¿þBÚºxXÀ>­¹)úþB[ÌTXÌÂ	ÃfÂvçqÚV
®+éË l´ÂÃÀ©äD.½©ÇA(éa=MJ8â?T&[«Ó­ÙÑ·Ç7{wbxbÇøº°aT{Üu\ÊÙ¨óÜR ¥*³Ài=M*jà´Éb(TØµ/]È&%Ø%Øÿÿh×OãHPÍÙÈ6ì,?|*[®Òg>â:m¥ÛwÕÓ;ÐõC}_¤÷yl~Ü­'GkW×§xÞÂz{úif;NuL@ õûb2AùÚ}kM >Gé*f*étu&g¤Ï{ÑµD{b´³/0=Mír
ºÞfj+mNs½í!õËÌÂÊèÈñDÐZ¨ÙPL0ÇýDrÛV{¸Xü= ¡ "wTWkwé¼8-:jçøz¼ÜJÝ'ìÎ.~g)¶¼ô8£»ï8­âÒb
áe-Nc÷ygjÉ-ÿ|YÇ÷x¤Dª¢íU¯Q¹Ý"aªßïNr¿¨ârlt¦Í
r¦(8ìø©¿g°Ø0'¸ÜÎå0ç'¸"aÀ¢°¿gvÐÎ@4®ê¯ÍÎtr¯å0¿ ¿gÐ&l4(a¨¡yHêì©$%(á$a8ª$f4nFð(¿'yrÏl4
Ø5éPè3úÎ]ú$¥Li½´ÅëìuÁ'ÊQãDÌ¾Á\õk£<¥=M7Íû	zsÏÇË*Åüõ=MîMÉ&áz«?tòËQ9 ÅððgÝ±:´l³U¿ÆÑ(1#1O´]»(1>²GÍ°_±NÁq´ùÍ6'6&êÔ@ íÀmèØL´nÜñ±(»Aëq^l³¿!%1O´ÍÆQ ±»a±8(¶¹ì¿AÞ¡'gqMhä|'¿*lÄ)ìÛÔ0¨B°îHå¡pw®8à0V>«À=MY0­÷®èY0¨V>«(Y0V>«ø°ðù_°0	yvÃÈCaÌCÇäô0uÑÊ¬kZ©CT{ÇGÈUvóe?÷^¦>¾q¥e5ÄfoQù¡E¥°33ðJ+É¹Ã»Æ~QWv(öÁ2'Úð¬ÎT[ £|M#[>ûá9EúÎÑm¦Då ®+¯ÔÚPX=}d3o5:=}l'ó¬¦c)PXAðVV/ãIúé÷Ù4v¤"E"ºLáOÊ	vs&gn?ù¿²rëRV=}9q±dì5?%å$w[ïàS¶Ì5>©§S:öèw¢üNVdeX}	ë,²u_+ì;®@Å<­_¤;Eg°$Ì~Lz¥Á^êrÁ¥²$¢Ìaiv¨ r2êMi3Ì¶¥Îà¯9¨[aá¡½U9
Þû½3_U ,­¸iÛiÒLÕ¦ìñº0ºªÙ¬¨Ä°Q*ÈQ~\: p¥¯N,x T¬Ó\ÍY<GöË°¡Å 2¡È°Ò	«Fµ¹Öý.ù#èºSã/x4ÅîMÃQøÍ8Gõð8ºo°\¡°r\= l6Úw¾ò&«XKõT³¾1eÑw-MTUtëÆGycÏµ£¸åp®d¡Q)CèbhÐÄÉÓN¯j?$Z cdT/ëdn¬M ÅÎòz¸ºG ¡àÁÞ°éè­¼È.AÚBa+sÚ0§rS½ö¢Á7ØNTPÌíÖ´2ÀÏv&AMAÎ)øÚ¬±HHÅ)[R\õ96¨ñ¢-ÃØ [¦&å?í¡BKF¢tÒr@ê-§zl'NnÜöê')VyKJó ®qîê1þ Vjn×í sÖl©Ý-XÖ'´ÂnØ¸Õ}KùkÓ|b@.ÌxW9òÜ£HîëÔøÃñV]èÜ5|ÍïÉCæLL2V/-ø= ÿQûV,2v5®³|YÛó?oJÈìãóss·ÙOÄOø5Æv´slØÝPÇ¢Í	ÿðtäcoÆO¶
G VÙ{R?43$Be BCò?HUxõ]
úSM¨¼LsëëIÀ¦±áýüîpôýHÞVnn «bíáå0qÆ7ÍÏéýQuó¤ÁV¸4}·{2&Ê£¢ÿu= )fÛß÷%+Y+È#
]v{ÿùY¬´ÀfÓóò+·åA?Öpð¡¿DZ¬Y4¦z£=MYa â»e²u
u_EÎ¥Sàë£L:w=MiÐáÎ£fÖ ~ÇÈ$-Lf_6 èi]å.pÿ¨c£<Wºs¹qA+é?ÊÎT³?l_$é^}½ËAoôy[rdÛóÎlòÃ@÷\¦ÑßdãôÎFjµu;MäL~§Ã¼iÙÊç/=}oæh+ï/õ¸Q/-Ê![~D!_ÃÜ2wØw) [¡Çbö{¶a+ùBþ
« ¢PÃM{Ö¢p@|cóëÇÆÃZ/§= øV=}oçwÊ9RÞ~cCy¡>Úqð8¶ª3QxÊØô¿<QÒ®éß ·
Ý,þ¹¿P<V¾GF~vÆÊfz¨°£-ê¯(w9}>!_H"ÞTG|®±n ¿>=}É8J÷,mÃj"qBM^_ÊÔÐzb¢VÂ¾áñªQ%}«}¹~o®]!ìCJ[ID½Æãu Èµï¾%ÖßY·yé²©lÇ~c
?ñÃ?[¹ n£çõ+þ¿Ò&e5Z2PÇâc£¿5j<DbRê¦X7û)7tèÊgW5ÔðZ%h©ZF)À^¾j2<­©0^$ê6âX&2= as¸bý-Bö!»Â4ôËy¹¸MQ¶AqÔì±*nz$©%9&¢Êéë¯
ãò1úÚ#T¸íJ¶À»%Ò´°%.æÇbÞ¼ÙÆc}-m â=}Ýó¹5rfdzK	^Yúv­½íj]¶MÐZÃGM®!¾Ä] t
Ð²Æ×,òîÅ$fTõÎ
Ya9tòè ®©÷ï!>0oWÿ¸âæ=M¶^A¶"¦¼ç8ûÃh¼Í¶§|k-µûCS=MsÔÙÆ³fhÖñ\IôNãïJÅÍ³Xãªf]N%Fçä/IþÎøÅ«=}Ãÿ=}Ä6Fýêz#Ð½¾xÆ"d=MåÓ:¦3Á vî®5}¨ÛÁ;|@Ú}:k?¬eÇÛ»õâ<²/	S+õP= (­*Q×<$4B@óBÇÞ5]ªqÁæ']W[wö÷Éw=}yPr£édÐIC[fHëÅTDjËKK¿T<Ñ¹¯Ý²0»ùY¡X¤¢üêÓ|Ô­7öe¾íÑØÅåZ·¥6Ä|ý °º]c; 0wè¶TUö¦	M [¾åûu¶Çöô°Ç¹t´Yª0}w°ÒtÕghÚÎw	Y­»î>Â@n³SC¡ÏûÖ~èú®71g²«a°7C
öùyµqdÊeQ_&ïÛK	Îh½ûê5£©Ù½9Ú,÷Z&\C79M®áJSÄí8IëûÑ	q(riT/øD÷èzòÿÉì´Rx![9Ñv6ªÕ= G ªÍÌÕg8ÂT=MÅE|þ¸Æ^Óu^æ"» ;*Å»+oWG0eÔ0'('|Oï(ÖGÙR¼8¿àvùÆG¼ÅT¯å;oþ¼&ÛÙ´ÓY¡|,öý86 ÓB¢jÙÚ¾Ð%%öIyçE_¿¾þVáe·ÓW6
§ü±eµVsè¾ÏØ·MÆæ= ¡eÕvç¿ßíRk?¢§= ÷Ã@xöÕk" .>Êh×:Ñeýýö= ýê"¨=MÂ= è-$´9Ä@>(ugÂç ÔI>a­Ó%ÄRLùÈ´n¡9 c¼Ç+ír%Ä.ªJÒ= D¸cÓ~e=}i°ÎÓÄnà	_Ò>ÓX^Ê»Åü þeQÇÊòÚá+RÏ[õYã 	÷Ó±ÚnævQóVcªsÆ¬ä©g½g¥ÎµZ¢¤ë6ù	ü1Ãqô= õ×¿@òÿÍÙ÷JÞuûHáN!^UæC*ëRÍë5Ývfß·¯»jÜªlQKyî­ÚÝÚ°ôéi¦HyOJÓ7ái?E¸è<Ð.çk[æ¯¼*¢§OÖöpÎÀ+NelÅfkìM®ä©0.°¦° ï$¤8^Å-M= þ7?süO= õ:pÍ0j®Ö5rº ¬|©vøâµ²39A¯_= u92DOÌ°°û5½pÍ0Ú0F§Üú£vÈoI/ï0åÜÉá²KÄ¶Õ:BÑ±):ÂRöu= ep­w¹R;0àÔÝúoªÜÜ<ªÈo©ª;+1f%V âã×
¨d½eÆ|/°ÒÏÄ¾qá1pP7}¬NâPggg^åÜ ¢°®H	¼3Rà§×3­,Òç¢+8y2_²= 1ÍbhÅPKÈèÍ±¸âÈÌÂ>
OÑëÄ¯©á"ÞI¶¼á»[Äõ:[¹dÑµwÉbÅ(cQZz¡Ñ¥y6bA» ¡Éÿ3ü! £½Þ^Æºpïiø±ºY1²´oøÇôÈóìþÆíÅs0?}.»	9Õòºpr|iÏ 9Ó÷CÐÙÏ$:2°¾Î)àÉ5q´³=MI@÷°/»CQÐÍ³ìÁ:uô³¯l¿8-4z2Äxô -wÌÆotÒiÂÝ·Dªg]²= ößd /»Èüéhäÿz17¢ÒfÃLgÊnØ{ ø7+Â"Ê¬ClL ¡áb,ß±s­R_­ R(óÀ6ß»ÄKËÛ¹®UVT<._ÇçæP³¦ç3Mã*þB_iÑààÖ¼C~Aûùÿ:4uÔóÏ¶3x¶î¹E¶§Ü(óÂÃ¼)ÕÁ¹K¡H¡Ï!ú×Ã$7XÓYßËº±xÂ¯´oÐ]=}gy,X ú¦ý!!jMz?'On>LæC
ÝÿßÚ)WñáØCÜ þD,ê¦#Ïè|¯Aà|?äðá¾â6IÉøÊT=}ð½ì½n½"·H¯2/8/CoDïÐXH¶+À«d.R#SÿÛq À¨= Kçml7ÊÃs2íaËïm+#Æ¤W?Ê\\÷fÛØv5ÆCÑÒPÒïÈ j¡È~!Ê±ÃñY:ÈbqµêsPÊ 'öÚà8ºÛÈ¼8°õc	jÁTZnV3Ë:rµrÔ¹?dúæhT÷ä¸ø&d[å{ôó¤±oøGw¢ÅppEWíºÛa7Ô¯Ë®2Åû4n=}	wJ:×­fêÝGæÿ×Ïè¹¬#1£';ÅÕpQTªòªmAI;#aåÁqéx|íª)¸ö*+¤%ÜùG;XyÒöºSÚL=MÏâcV=MlD×RãúQÚsiDk*¹P]/Yhm4:^ÌuÃNLî»NKºQiÕ¡¶N3)±pg»iÙd_0OIÊÉËb¸ZFGËl'ña´acDåï¶rÂ´	ýõ=M'öûo$8*¬n(OO$ªP$¤È¿¦á=M¡fzXo«6Á©®]Ü*O¼èMl¬èøhãv^kÇ<çXNj
6õÖ]ª6To|r[ÇOgIáù¢t¨K739i]CPæ¥ÞîS'NÝ^äIç,§46¨­{Jd%RS£÷ÄÜ?=MY]â'¥
m\7:^{øû\¦¶äÈì=M­i
w$ªgTôç!Lå×©}@&SUcî-§VH+×Ï|×/__h+>×ßòüè\ªü/_}¤è­áz"ýsëæ¥Xj~!¡-ö<Oþõ{Ìð®_ î¦_]\ K+=}~=M³Gl­k¯w¥C¬fðÌýPD%c¦= Äõw,¯Ùöcá¦Â.µzËÒe1¤TzöÝèÑwÙ"8v¸Ë¶¿U³«Æ:*](:éô2ï\µ<wºi¹AâÃÛÉgaPëÞþà VÔ@³*Ã9=ujõéDÕÏ6øÃ¥ö>&:ÉÖûîv3ïzM;yTõÎ)Ä1Ês?Áagceaâ´°ÔCNy¶¿¬Î²ð9iþêU²&¹eø9ÂÀ×ÏpÆ±*¹!Â Rx?!S»Ú0Ã¡48T¨Å¡l0NÑ¹q¾eÅ¡¦è²= ÝçÍ¥äëPvqÆ©o´y9Ì}KØD­ñÝru#æóúYÂe{Ö
'³Iú}àõòõf5~k{ï|MÂCR\åÜª1¤Î¦½­«èzÙÓÉí´õÌ¯ßFQjÐú¤B÷µAøð{@´GXõÝò3À´[:ö}1IÒÑÌÁÝèGðjÐÁ 5}úÔ´ËRß´hµsæ»º±Î=}²øö'rZôGaÄ¨¹ÜFÅS3ÝÓèB Gky¶%ÂæQñ÷ÇriÅ¦º}¾¼¿%Jì~wEú-Äôéú¶êå§Vpl\no«Ü°(Ó.¨WÄ*åV5ðO&ÓØ­JäG©ºÈßòÏkXÍÈò
zL¡þQ5,¤XLÆª)*Æ**J)}¦Kt+Ñ,ú#ÀÊz4v.BÓRH¦·biU°ô

ú0

õ"wì*z¦( GÅH°_iUôô¬ô¨Ì;¬ÀUFÅçæÜ-¢ÒT©1)"TéÙýÆ;ýmm5v~¾vÈ#Ô.»·ûä§æåÌ¬ç|A8¹p>åI?äôfäÅV}ñVà:JBì5Eª%$BÛogF_åuëHG BôÏfÄY·)ú{øw!{
ÒÛt&-Lâ$u¤Íe ¨©Lì³ªL Ã2Ú  Ëª')X84Ha%½z{Áñ{âÚ{Ëê­HÌÃZº
¹vDQyÑ¿&¶u÷Ùµ
YÛDn»h×Îì(nSgf@JÎo4Xû|[Lkê!kµÞ:DO.ò=MßÒæ©³h¨Íé&òþ$@[«õÊò¼T(WOÝi×Òê÷gäôýé)«4Hþ5wõ@L§ÆÙ0ñ$ýÍ3= >úë/ò=M~Ê¢Î4È= >úÞn¨cZ8K¯]6ÿÇ]«xÐ{=MÜüS(°Ñ/«oNÊ	é2s§eÐn©ù¤¥^M-È¹C@È/«Rü|{â!úq¬cV8^ç,¥G]¬= KÖÝ_¯Åø¶ÂbÊjVÀ+iío>q­æâzØà9å%[«§oR|Ó¨UPÙi®mj8äræ)G54*vèÜ,ºg2Vc¾,ÀNj¯kf K¡CÔàð-¥:~kµÝlîä¨Ó V½ÞN´Çø }}ÞÞ,~YËKª5øÿë²¢è¦YKK.Èe%®.*Ö¨fú¹?:©Þúøïe¦âZO¯¤G 9é*¯\§ð&×ÿ(LnõÅL-©Fø ë*7ís6?®c&ð°ZéòugîJØt©i«ß²<SòÛD!åý¶ß¯¤_@þé!úô@ð,Î¦pÉë{1ëýä%ïÖ²[u5¬èÐ¿Ú´QÓã5$JùV%½Ö2Ï²=M´)MäÍÐþëïdL_U½{ Ðg®¯òÆôô½¦6"3\8R¢rd±­4XL²x1[Î(ð
ò4hA[¯XÎ¡©MY²³)ìòXBU¼Z«»Æ^/C~ÓJØ=}ÄÑUIó»Ð,±åQçB¦í,&Æf±-Ùº"]U¨CèúÍÎyòñ¬òu°y;=}¯zø"qDÒuØ>áÐ!¹²ÔwlL'S_c= cà7Q4V/Ð´Gb]àÕApåËÞ·­<½>.@DëZuB!¥J¬=}×=MÓFáñ4Í~8É½Ñî&´¿^uu]UôZj}ÿ·ÚLÑ·AóÉ¾lÂ#kÿ7= ¼ÕxÂ1÷îpD[ßé°¢ÁúÙ=MIá»c?xf1Ý¾ãtÙ»ûa0¡µ§ÖÁÞoó÷ô%ÁySµ= Ææ1 !F÷Þ¬Ë ÞU5ñ6ñÃ9á=}wÔ¤Ve¿]W!inå@rª§D=MÉÎÁ!ÃyÐ°ÐÜ³°{1[:ú ¡Ý6Þ´Ôv5$aPe3½ªd<y×ÃÔtob¶]2Þu#ìI»£Py°ÍBnkÄ= ?9
½@â1æHvµò¿¤»= 1¦pDªOÞ19ï4È÷2(Å=}·À!È3x_0}¹zé8IÑÛAvÿQ:BýîT@»Gp¹6 q¾mÒyaÅÕãUÒMnMû»¬ðýè³â"þ¡Ùü2ØJëþgp-/¨Fjêbç^h+£= ³Ìü$Ôôîæ²>¾0«¤[È;ÐjÙÙqxzõ4ñ?Pn+®3H\ðÚphSI¥]4ÀÒ@XjmMµ(êöò¥¢þ¢ïBlØ¦ùY'2ømyÆVBöÓBÙ
¿ò#ykQ¢o9 Î(ÚµÐú<M~)Fgäççs,Fõ=Mý=}y(«Zlh$§VÇ0N®§T×¯X.ìvÊVöÇÚþÆ«)ª)+KÕjÈ:m©!üXóJ­¥oªÓÎÊâÂzLãE÷ºý»ÐéÕÏãp']cräÊS¦jâ¤p@®ÏzÔï|%ö2ùyø£wÈãà<5$6"b­x¹¿®eçMÊ/UÙ«0¥GãtpNTÓBLxGã.ÈÌÙ²¤¦óÏ¥)ÍgUyrìÑâ(½HPöMÖWß=M= ÌäØ´=}ô¬!,Qj4ÉIàÊoä§CXqäkÃÏÂ´Í'@®Ñõ»»ýû9¾õÓ»)³bA»e<V ¹ßÃþÛFÔw6[¿.Ë¹j[:Y"rrâ/Ú §5xøO¼Ö@= pH@o³dúWw7«Ä¥%&efåæY{aÊKÓ
5»ÝÙí=MGm)©'ø¯ "ì«?ýùV*óÎB¯ÝÔz¶'40¾-°©§v¤@à8~!%ahuAì[ï:/«b¨«áµVý¼R8mì«®å:/ôPL| ò¥Ãµpæy·ÊFöÑ= zÆSk©jY^­­»(Is±Tô® Pý;p_P¤eÚ÷ëí¿ô®Ä§ ÜÅÐ=}Mæ.SOëLuRPPjANjt[¶rï_?³<zW7+Ë=MçþÃ{r¨= w_M_üSsÁÈáqõLÁßl&é°GTØÝæ°nX¡Ê÷Qy3ï¶*g&wµp½®+ðO^²@Òº
Xë"/-õiXNJb_7ÛôS 4PÆuµ"úF"NbroWøªb$N×"!äí.Ô,[¿¥æé)R°%ßWµæK6ô3y¶EÐÀ= ØPæF>Üÿ@#K]7°}ùzvT¨m·pøR=  ~§CÁÎÖå®@nK³Ë®Já?ÃË]ß?XT=}÷+ð9@= ¦NSW9÷ðhðÞ;yÙQ ´ Í Rö³eÒúÄA-}w,\p¤^TûéC= n~¶¢üMþ¹¶0¯,¤«±ÌîçO©øØQüñ= ¶YìòÎ.Â¬BaßrýÊ¾&­á Â¾(×k[ÜSR\sªÙZpNÅëFslgªJÈ&Mbr_Ö¢¤µÛqÀ¦ìocËwä£jÊQ$åÅ¢Hèlf¿VÙö	*ï/ZõOÅhRðë_ÎÁq·d¡HÚk,¥âò¼.j SRPÃWÛRBà~ñTCº?Í*åaÃÚ8÷p%íù§²Qd«}ËøÞ½XkÌÚ$^*ûx{ä-×£©x	¬çK5¥ù¥õ¥ýï*­«­¤$qQÙ>P´Ð!~æúö=}_ÏÖSRõI±Ë¾o åw%0ØêcoKàÝäÖZ®BR6½¨®ü?ÓðhüKýÚùÄ¥<MeV)÷°«¥¯÷£Í¼O;½J>-éky¥V¿+Es©¨ù$²ö¢X´vBb¦ýÞî³ÈöwWr%ì@oþLÊÉg%¦ÄûþA êÊå0
Þty}$
k>o*8Ý	ßóöÿÿÿòò ÆÚÍÌh£ÐoG-ÏÊDDZÚy*Yi ö§^ÙDÚ|«FëÍJMAãîûç7Þzwãc"U7ølÄ¯sàÝÝ">SôEÜ#;{Æ-À¡Ê_¹H£±é	=Má¼jCø,'v_¬0'²kÕ¹´ðg>gggg(&ß×ê¨ª&.s3okÜßàMb= rPp©p|¢0 !.	9ðÒt0(v©ËÐµ¢úò¡ûÁÅX¶r(X¦&-w½D>@qñOkÞI¢E730\JqÕWá>Ê}¿¤	qÓGa=}Æ5Á÷µuÁø³úUA÷·
Aø²öE÷¶ø´þe÷¸¥x±ô=}áw]z]|«yw{z|§y{z|¯ÍyrÍ{ÍzÍ|¢MyzM{MzM|ª=Myv=M{=Mz=M|¦y~{z|®íytí{ízí|¤my|m{mzm|¬-yx-{-z-|¨­y­{i"ÕWá>Ê}¿¤	qÓGa=}Æ5Á÷µuÁø³úUA÷·
Aø²öE÷¶ø´þe÷¸¥x±ô=}áw]ñþÕóÀL$éÔØîH>êL:É }!âárýªK?:wSúº äáýYJýæäWJº HÚø¤ý$
#KWðø×$~:êh¤gqMi/R$hù <eõü~>Xæ'¤#6$hJ½"ÿôNás?¡	USm×mØ,]B^õ×
ìÏÚ§ûfknäAZGÝæYÞ>*Þ$R<¥SHîF^ó@F+^$>à<÷JåzWö÷^cH
XkÔ|J§|'wôcÏBªI.oo7
]×I~+e2
ÌLW9îKl^Ê  ìëXììdlcl,+ æ¬,2$a¨Ï>t^&Uæ@g§"§érØ¤Å,PW7ä#gKªmù^HYªãfZ8\¦#NOþ+m= hªßnÔ4¬¢QýÏB~ã+ |ênÙtHªKýEã/ Ð{­0¸ylð®¢­>#1d·´©ð4èà ^Nd ,§~g~åfgXZZ^ ë"ï8Ä³¶yÓÖ!Æ¾úîI9÷1Ë¼ÕÁNWtCªA_³'é$ìòcàÔrÎ¸.ñ'æ9,Ñ+ËlÁ0À¹=MNú\Ñ³nf5ô¶ýò'¯0ú/Á¥FîCßÀdbø%U8ksÔ.ô­÷«Ý
xØ ¢êÐÐA]Æþ1,ÕQ 19éíÕ+áõ¾7un¶}z¶¶G=}>9À=}ç57Ó ÓJÞSøùBCo¨ÕzÃcÃ÷×.p=}	T³¨ñ¶üÜú= [u¿\5¤\>Õ°Ëæ¥fCî	<	\?ër¦u·}¾¾iÌ
£.Ô¢Êþê~M¡&äÇcÆ+ùÐ÷Òtú=}q­è3:BY÷BæËâ·ØwcTbUÀ?t>)s{ºYî×Cãºl{Ú¥&hCfh¥õîÎYêNu\'çwtÃäF©£%+_0·[Ç­®_Nü¤ù÷àqcAöYoI%>i[Èèa»üg
>åÎì~°f#ÎCTv¿_8b².¯÷X =}ÉnÚnLR3©Þâ>Lh°'uH1-Xí¯lQF{¸:Lo¬C¥ 8Ç!D¸ãµµ¶cºË´g¼57ÞòÏ·s-ð¶£NÒÁ|¶§ærþîÏ£ûÀîxÔèºiZÅSÀâ@Æ.åóoõGÁlEBÐ+Æ+¾+	ÎèfæÑ¨so3 é#rÙíÇl³Pze?mWÌ¤z%}§$A^¼<i¾?"°Ý´Í
±.0Gðgèu÷d,;ÿ{K7fjvR'ìf
«}h^µÇóé=M³Ë´þàæiöÄqH ¸lkÆå$Ïù»AAPò¼(3fé³ïª³éXlp³Î¦ÀµÞÞsÚÞºæ:éÂ'¾Ó×®¹ºö©cf5¼5Î,6A®= :! {â¥étf×ãóÞôðçäKæÉßªÉt|OâòÛSOÓS?ÇB<s
Ó§Â§ùu:æËÑÇçg9jâlv%§übwñÒÂõü9n5.iöó¦ú©^¯GEßIÞPEC÷ãÒïWJßTH,ÜjØ ÿdå#þ= À#p Ùý
4LE?¥ÓÈØÂ= |%khç¬'[ç*LD¥UôÄBß"HO¿UØD~¦T= ¦2²ðk²0×rAêyÿ?çÓøÉºÌÄ=}æb>³ÄqÌÄ)Ww&Ù~*tÜ¤á¼[úGdÕâêBd]ªMÌgVód]3OeÆC·"´Zî%{diòa}$ÕÏ/ÿþwJ÷=M$çkeü2o+1o¾É¹U±kä±¦ÞÑí;Qâò÷·'3¹¿»ºBÇôÒY>°Ò¡TÂÏNâ8 <³¯©Ø¼¨µCOù¼>3H½µ¨_õUµ!ÎÉ-ÎwêÍ6bx)÷z6½ãË:"Ñ"ölzínðù¹d&	T}cÍÌVÐSÍÌSm;¯È (:ÆJûú°8Ö%!7%Y~pHÃ>]2m1È>yÆn«¡ý{Vl$í®OÌ¯l= ¯5Lf·­­t7þÒ²wlèãÚ"9ââÇw
|ô{Þ¬§Ù¨Õêì¯¡ð«la2.ë|[(B(ôqÃ§õas¡ÝHd{¶î¸{K¬ígñfÿ ¸w®cåØ*}L}½ êÎj$v¯âq«k~GÀ,ÎdwÜM1kÙQ&ï¡PÜòB¿4ÂÝFÑ©$0§_vn8w!é4âmÞ½´Sq¯³HðÌQëcº"_¢<bÈj&/ÝJ£¯çêÇPu¨-qIKå<S:RßsªÕù ~A&çË_Wæáf?©nÝ#ô0hÙD$Ì~(l¿ab iNWª­Û§h¢oøÐ¸à
Ê_{ã¬_EÌnª&[=}}3ãL¢æ@×Ë¬"èñÄe9¡RÅBÿëÁW5(°7=M·yþÐ/¿&,´ùõi
vPzÂ~	Ù¯é÷ÖÖÃÞ¤°+HH[Èj[ù!êÅ¬?è"®©Ûãpø5/oqkZ¬ÓÌ\5¸D:OÉ^¿Å7wl1<@Ä©xÞA/ôºü½zç¡ßºcûú ÉI[ð;	>!Òôò^¼«Ìß	H|^N}!±}h aIÏ­PbÔbÃ8»Ë	X0#<Ö#è§p"{âLPÙ;7PÇ,Ðð½ËÏC¡_÷'mjñþ jÐç%Á¶ÀÐÐçßÖÖ( w ½0þ«x°= hO¥Ó5«Y=MåÁ%ï6H "e-ëIÐjá¡Ïþ³ó´Ð±~ñzÒQ Æñ)®³%ÿÕ± ðWöÜ×÷/®´k¨X#%l·È±¸³bP°:c,pÑg½I	¿5±frq%³}=}´²ÕÌ¹É9Ñ7µyÑ8Ç%Q¸´Iq³ç!5ì­Qõå»rÎ+¹¤Õî'!yá0(ø6:BÇoRkáîâkðÔ~{õX!õ&ú#/=Mõa= lNjoÉ±w\ü$ÃS¸¥7©kËÁ5BHÕ&Lcÿ»$´ÞãdR/öÿ­A/îtð8V hçÿÏämWÝðäê' YpXdº
ë= wEºT7ÇWØ÷¦°ÍP@Þ
hG7ú÷GÈXu.úehz éÝk®¼%¡V//½öêk¡FWP²¶Í=}E­ÁÇpg8m@«ÚÂ¾¶ÌÓõÏÃV~!W ûL¼FÐ¯ð¦N#´Fn8£¯/[5x6Ût7+eö[ÄÌï²*±7°Vîoiîëp}î= îÅ;¨î¿Ö¸ï¥ÃïâÐïÜï;éïá÷ïEÐïpøï?w!ïaH0ï8ïÀ@ïIGï*Oï!WïÌ= ï¬hïÂlpï÷ØyïhSï)ÛïElï½ï£ï·:¬ïoÁ³½L´ÍòÅñgàgLÈáfg	b~À«öæ¡CGµí<ÿÿék'ùà;÷¥£Eò Q	R´·¥èRbê¤÷	zOÄÎÚ,3a§ñÔL|T®YËÎy8MÁ×7D
È:\9@é;ÓÄcÙJXj#äN¿äjoåLm©=M³Ë¤*;=}76Í;ÞSc?=MÛÒ­Ú\{I$nMÈÌÛÙÛ]õôôÿ~*ê<ÅInaázRû÷¨¢	WtÏÆï\Ã=}¿ÆÍ_Å}OØiiª=}Q¨Îr¡È3ø= ¶lðºw0ÈM®Öi®øPFUÖ®øZeÃx=}¤ ÃþÃUÉ~V¾	C¸nukëc¹ºÒ*
¯D£ÿG%r=}jðVëoû&-ÅÉoFz°=M»0ÙvÅÅýêÒàéeö!VQír:3^ó¡kñKÝ¡¿Âj¹ÏL¹ÀÅ]à©ªøvS+ÆD\i!ýö÷Æ«dµ¼ÆX=}§â=MvlÛçâV÷z>¼ûgÙ"L_Ui	z8Ö¸~F[u§\3@èÆ-_q$[3ê»Ï)Ùæ	rkp#wFd$LÍt¢#/Ø{Ö)ìê'F)= ªû-DÕh
ÖäL)= 3ïÜ9[]Qd3dÜ©?-ê/t{Ú£ÞXo,êE"Ê­Q=}G~|yl{AVÉuEã"ñÚgÖé]àÿºÿ7Öé/Ý?;<báÞ}XÓ%hÈRßÜS= 9O¦6%ùûÒÞ,È'²»¤ÙðÊR,å}D%a=}U,ª%JM 0X-÷/z4f*µø"eÏTÀcÛØHïn$*(ï8ÆêÝ>¿9³%c"iNvuR
É'ÔDÊ£ý-¸C#ï4lc½'~2%ÃÃ¢MEæI)V¯ëFêDº V#»#ië6?ÌCBÝ^°ÕÀ PÕïþUÝéBIèº]ÍN1pµS¨u$ràOv"CxÒÁø	_xã°#½XÄ9­Íþç(<W!Å<ÝTðÌ:÷)Õ[Ó¡à;ñYöé,5ä-É·}È;f$ÙÈôéÄÃs8råùºù.Á&cÑuñ7|´ª©à1ÜÔ³Ý1­ª{PZD­I@Ç-*Èxzïå4~µ Oæ¨xÙà÷å¥óYí*¬t4ÜvÏ½/L½(eOl"ð{¾fÌ_Ý¡#âÈ=}Þá}£òýKulÿMÎù¿VêQ*À[mQò,ß¤RÎ<"	üýn¾ÖÂçeíþÐÄçÞbñÜÜ|Ýº-r.Ð¼çØlpêv}©¤rEW}ésþÄ½XÉ¥v9l÷-éyr7Êñ.7ªm@}+EC.ø¸¼üÎ×}×®lÇÈtfpÄßKIÅ![ëh¦ZÉð5æ4ú%Ë}kö4/ÐyDQ2=Mé±W´9? ¨î®ÉoÐ¬)UÀl§	ÿ ÷Ï ön!:¢Ïµ'2*(gÎwb§ù {;Ù6ÂN*j_Äø')&­¿fXcîÔxeq^gýÏGp°º3¸1ûQÙ»1<g*¬gÔgg'ä 6JñIÁ¤ÇÁô¶
jF±,w§¡dÄã-}Ö>HjHÐ£á×tvõ:<B×Kë6zþPsÝ þÀ]×â¦}"Ê4ù¹Sï¾Ô%Á¤¸ÁÚ@Ñ®¡Ý24È}&SvTÎKìQÂ37®~á» 52·}9_ôªR¡vô¤Æ/øÑ2? V³O1ÓÜu÷¨-E= ztQ&¿¯ÝywnýU9ñß¾
TÚ©¤êÊ7þ:	&ð²\$/ÓÇûRÍ6é¹}JÊ?ëªÉ½÷<ÑÞ»ñº0»¥öÛÐ¤ó ª¿_ã=Mî3þ/ÿ	9PÛ§ dö¬.Ì­ÿc3¯çü!ý}¢D|½8Lqã¹K,¾âÐL*¦ª¸ceÑiüÄ£wáÌv6øÛa;3ËöÝBxªç
Ýîà´. Ú)ùùS]àÍ0Ò«(¦¶fÐq¤ÇPÏms¯6¢aâË%ÐÑ®­}Æm6EIY¬$Ê= 'qNgä¹hîº^xÕ"É«ºÍU®Ò­kÈ&ì"xÌwrúÌ¡x¾¿ïº~Ê|¡çÂ;pø{ê)Dè´·cÃifÅò3¡t!ôX*ãëç@Ã@Ð.YX,ÌMÆVÈDàå;Y@X_.BSÏõ¥+8ÜÊ|Fó$ãù00cãºHÖª­%¥ìkä®Ò*Wqdxù]*À{^ØöeïMm_"µò¡±ÁùÅñ²¡ggg0dæÄ°9à®ùôT>{@5íKúª«2øÈgíe¨.©¡;#ö-Ì¢uq7õÐTdE«*[JôP#lö¦~4;}^WKwY:Ouù¢µ%FÍ*¦I)¬/ÑÌ¯B¶Ò3óºd>Í}Ò®cw5]Æ]!Ñ¤}þðÅógLõD¸Å
ùÖ²ÇêÕ¬"âªòï	Ä= 85j^8ùÉ¾D«LuR2­ù2jÎ¡G,îuóskY°pÄ'²,ädÐvÐ¿^tâ-ï:lbý³-|Q@8W¡Þõx¶¨8a­§µÀÍP4R®Æ7_mteøùÖ0²¤kÐ9­«ÌCç°x9¼Ø	"AH´s2éëy8üè5ÖÖ;âÃÁIE·.Ïwcûa:6e3ë õ-]Ç;0ñ È~«Yj¹b=MÔ)¢Iñ6ÊËN~'ÃeÆ5Qo¿Þ§Ym ¹Øy¼i»èal}æ Ù+2>z¸6toy¢x42©ÇË5WÈÒÉàÀ6Úé3Ó¡Ù»Ó8aÞÕÇOuTYÑ²îýÅå+º]D!%»ÿVs¦	ë}4ãá&è¼%çÿ-öüöÏ'cÆÑk\ÁÊv)â3|[ååHV¶5h[Ë¬¢Z¿8@ç>,ÔÄ~ù¢rg1ì£ %O,ÈGÎrÚX)83±³h¿Wrá']ËvÌâÅ>@Ôñ)Ã©xé4$Öd)¬Ïº¼ih(
¢Ãò¡±É³±a'ÌggD goË\ýè@gQÏI.2¨§O-]öc" C= ¥tï)5¦ö ,GxZc¯ýÊq0¸¡©ñWlÀ°X4a!áWºô¡Rq»éFÛSZ_uDûW=M6þÈIëóFrÉ¥Õ&«ª!b·Âäæ:¹«$Þ+~!A¿»à%)îüH±îÛO¢$[ï·=Mp1z	ôoÌB09ÕZâ>ýi(µRE»èKêÆ}o¶ü-ö½mÖH:};8^ÛawHæxÈ¡GêøX;îìçÍq8¿¹ôÎªx:jìN)Ë}røÙ(j¡	tÆ°~_Y8j(>×(Ç¥¦Q"2¸ØÍíJ&D8,v(Zèø8©$:ÀøÍ-ª+H>º/=Mlx¡ë0/¨Ø=M±zË2Ïy.¬Ñ»§¸BÍÇ}R°3
EÆsx,ÒÍ^ºV¨8¿ùt)äMbs
YÉ2]¹½&ÓJeéC+DÙ?];Eå¸øÌ4)½îªkÚGÓléíèwÒh?x*íZºí=MGq.®õÃÖÓüS'#Ã«®D¢ÏG}b= zûò®»h»oE{GIå'ÐútsÞNº|ª½/'UTêD}¬JÝüzÓ¢)ÇK~â6Í·y#®Õ8Zj©Îzö×@¥
*-ªFx= ;-Û¯xd1SÖ¶my4KómÇ£^9/¤<«
õâ?Æ3YÃÀü!ÀÜÖÚØ+Gâ= a=}pÀFBXÿ,ê¤GÄò¥»ç_QdC¢Ü¦UCÜ¯¥Pv=}ù³[êáTK}xu,a¾h9(YÞV°x^ëG= 0p+ªmUÏN¦}%Qm\2ÚËÔÛüÌJ®YB÷×Gåæol:K!£ ää?ç$m¼BÒÞÉ@Ò	¼lhcwpFdÃ§g¥RF8ç¿fâöÌ\eR_F'>Ø.0ìû ä ñM2U¿]@%Ñ,2B
ØN=}ÿ_ õ
ö}m±â~fÇÆT/ó}^ïúÙ½GQÔr)7µ¢/º7(Ö¥DCÜ&SE$^+FãpEÌK0ûjVàOP=}jãoûÝOÜßÊ{Ù+ÚtppMûÄê(-]ÿFd= ?ùê|êo#GDä£FMNîµMµoL¼Y)¹eö¹	¹IG¼f»¥Ïß¡)c1³2J\¶£hºeÍÁi%èTÆÁ¦¨7ÅBwkBEAêL?Jo((Üú}ç'<^Á×9­¯¬_¦¥º·Ègä	"HrwØ½÷oAt·¿ã)©ì4&ô½ÿÏ¡ ·÷ÊÍËq£è´80ãïq1£ì·åÏâÁsq<½5ãQlM²NÍ·s­Éñ·óÉ+x¸ôu+ïå×¡Ò&ÇÐø|qlb½ç^Û´ÖpãÙ4«ÿÏm´ ¸Ï-¯z6gßm@3®	ßíê|2¤ÂÍ"qY[Åü%(ºíE18óº9ÏÝ·|¡Ý3²ö!Ò-üÝ5sO³!yÙ1u-)IMÀF¤ûùÏ	g3Õ3¢ÍYLC´,Çt\Ý	D¶ ³üÒÄ1-ë=Mþ8Wså!ý¶|úZaîâ¶c ×ô@ÕBÕi	B¹ÃQûÙ²s]Í)xs[É¹92gaçÜ»õg÷sI|Âaþé%ù7tÇ®áÉ'º6B5Á~À7Ì4Q¤ùÑu¼³ Lð])¸ë .Ra¸ûp,4ààé«ÄO®§1pvÀèÉì»/ Ñ¢Zäé(êr¡ø	!² a¸v'F¼2çQº!0»2ÖôQ.0ßMî¶$s:µ¼hã8¦$ñJÊ¡?3PJáÅ×|LqF¬÷qã5QiÊS±= ¥~ï>2zQ&ÄÕH1·8s/Á^2L/{¡ûëa@þ6rGI-ÓM¦M±ø«FnÓMç1#DÜ¼'ã&!Í¡UQOÕ|Í´ 
ÃÑÑ·Dföòmá¡Î	á^#E¯Óôðú$¨è£¤Ñ¢®øW90ÓnU¯ÎªY©KÅÜoÑ<OÂþZxÕõ²°*8.iúO%AÄ^^u= W:¾£,ªãÚ ÃJÁÕÑóÇfU,¶Ó©+7ëúçÏî÷§~ðóëóÀÃÎTÛ#àÚúÇ÷O×\ÞèAîÓzEFõ®ãCÏcIµþñOGD¤qÖ#	ñBW$zuáG5¼ÔTû²u(RØ:Ð%ÓÿçõkzCåL}Óç~Ñ*ô5»j
ð:ÅþÑý:ÅÇÖÔ/b¤Uðd¦PdDdnÅËÈT\¼õ'd|G!q$u­:¶l[!ë¬Â'dQtëùL&]=}\¦¦4&$MQúX¯ë6Ø¢¦ï|¿ïZ0ÊÚÚÅÔ32¤R3Ïÿ2{_v³lB¾3wa.3ö ¹3µ3ºÚ~33,3\#= ¶Zb´3uÄT³hã"KS×þ8_Û@ºYBYË^\ô®÷OÊnJæHßÃfTDhiî kÑ¾#=}Qxì+¨"çÞ@ßSÖ)å)¶^ñÞ%Gm$ÛfGg: U]g ÊrEkH­]SªK88)Mï';Gd%¨¶ìüX"JªTZ¾åGýþg«nNÞ(Hßo¯1gïWÆ^à= ìÛVîðCK/Ë®6¢NÿçõPÆ=}ýÔÒÅ|óô¶Â-Ò;ä«u!Ùó³îËxQ£}bIbþ»cUâÔú·Øç|S½*]R1+Æ¢?|)Ý[K1jpØVQzÉ(»«» t2£Qãg-r¸æE=M\?møËYZZ6ÔÙ-¸þ·&"2Jï¿ÌäÁïËS5?âo=}ãr¾WéÄ8ô®©ß¿/?sØÝOÖ;=}	p[æ'b"Íò #q¨áMÞfô¼,M©²öuN¡KCä·Zj*´-ï|¾ kûg¸û3ØëÁà¦woïÉ<VK/çzÐLÖ´¡¬@±0Î9ONòI$âÉ~(6?;ÄÈ7uçÍ¼XøQ¨¹Ï:ÌÛTZÙËNaâÇÐí>öÍÏ=}x±µÀÕQ§Zõ%~ýsz©úãG= üò_ôÛoÌýv\,!M,ëËùxXLäárÛÄ.ÏOÝ¥ywUÔ©±#¡¡~ÍmÄH<.jv~t=MB-Í
C@ V»/ö²CÝu¥¶6i«Ò»ÆRÂ¹Ùwú;¢¥=}Ã=MpRµ/GQõÚïYÜvgúÍÅä¸>iYJ|vAü=MËxtSÑÏ÷ míàtã%
7(|!éï;¡¢¿Ð×ï/õ·¦]ÉE¼QIrCf½¯éuÂ²4\ìÉ°Er@î½×./Ir@pÊÊ¦À·¿mqa:²Ï·çáyq=}H-éfCÀ7-1|·ß>íN|4 ¬iÑÉñjà¸=MgE3£ÃAÅÜ²ö4!#Û3Qó¡;Ù±<-Ù#´öt=MIç×¸'3®lãr×Ý´©A/ëÆ×,XqWúáAK¹íÝ@94OÌâAZÄ¾­ùº86ã Ã³FÖòa-(±Y»­QY|¸ÛÐ,2Z¸ík·;>ßqìµ÷\Íqçr¿þtèçMîäÈÝICêyIrSqJQ½<¾Ò¢Hï}sïÞiÂ^²HËRÊ¿L»h ý³è¦ºQPS¹À{òhå!ÆVq½=}Õ:rvsåûs$0C~¸:r@u¢¥.ê¢é£9oôKiÎ5·æBkúñîj!íÊéúÛE@A&>FÕð.ØzAý_ 	ôË½GBKd¤úôç8YVÃª9ÉS  ÷N9è¼S.1Þ×7£Õ)5v0ÂðEjy/ËmDîm&ÏloLNé»,×®4$^àH^æ%y^Ào¨cTóøaòçáZÑýmûA
ø¶ÚÀµµà.ÖY¢ÇÖ«®OËàýÀ5åjÝ9g:Xïx#Y:ãÛpA=MÿVÞ6nCy;¬®øÚ!BàX°æ«YlJÈS? ótØe0ü£O°ý?®ûhpÎShÓ5s÷µÐþÈxx	4Å/Ø4²Ò£äºë×&vMâ¾X%ÚGËÏÆu¼fb[Ïçèq¦û÷	hµfðu¼ïdâ¡9êoÍgõèø}õÍ!ªì¥P96$M¢R8ÜW8jT=MeØOº¤÷<©Jº2I¨â¹= 7÷/É'õ¬ùe	Ä>ç7bI-Ú¿(i×,Ó§cD¢RÅíÙJ7ëâÉN2ÛPãBTF>Ò/ê)eÑÈDÒdæÐàq>¼B5L;¢gºË<H_7My·îßûè$BÄ~tì *éÚf½zDãe"eÛïg/TØ!¸8r¤øÊvQ®¸·¿ä)E2¾àÊb>2þ·Ý¢%Êq¶Ï= sQÆ¸G1mâ-äà5ìd¤=}ß¥P{3P×ÊaÛÉPú³°¼¢a.½)jõ3ÁÒò¸:ìnÑDÌeWìòKcÎ­í·ÌüAå4Jì=}"fï¥³Ù6ýtZÁãÏUnÑVÝUü:2;z²ð¡7á ÏC´ÈzCiÜu\¨ÍÀéý-( ÑÔ\ú*UnÚNu§Ö×ï¨åÐÙýëíR~È§[ërQkµ'0.V)ò#ò2Cbñ)½~åYç^ã½R*ò.ÂÛgOK&W()%iËë6,N7è%g  Y¨ewkW÷¹füvÍ_íÚ@úÄbgËj]7T= ²·ãr¡Îd"oTÆ?eÂ­@¦V	gÎÈ¦÷F-0\Ä=}¢t¡7#ÅKuuSÝØ² XØTuåjD28d-üßwZóMqàw {VYg242 iÉëutROãEêrx³Ø· â¯:r°òÐ®^P#6[5Ë6O»çcUga¥¯â"°g ¬5wcWc%¯f­¨4¬¨¨Ý|Eö	ßÝÐðH°/¥ºJc¯C­áÜKFu{®$ª@x·°¥Pbû	--GAÆüSY_u°Ä:æf&¥¥¾ÉËÊÌLMç,?jjV=Mç²afd(!%#'äJzgb$%'&¨¡£¢¼½¿¾@9;:üýÿþy{zÜÝß£©kÄ&
l+¬¸8øv×ÕVWÈF£©Æ¤Èàf'tW^(Ïé=M.­Ê>WgR¢*Ö­¶ü_i&¨¯TØ¹ßæek°©ª(Pp¿@d£?~Úk2¶LëÏmÎÍG1Qå£Þ¬  p¬¥~xRzÛZ6|,©Ë* o= T#KgR
'Ð\j¢öqAEO#ª+ðÛNf]cgh"ë¢æ .ðÓêtè(Rü(,øÖýtIî©©l©]öø+Õ=}4jà¯ÙÇl¥)PIü v ÏÅä ÞNlh®8YÞõhYî$oøÐ%°4î0$«¥Rö^0G.0"w6æ'k,¯¿á±5Rá±WÉx\öûÒg¡À¢û­´¡±¹PwRÀ_2,¤gÀß!ë¸H;ùÞ/ûÚâÏdäûëÈ ðÃòâ¹¶±1(g|gG|gL|g~/g0x2qäòWmÍ8$gªI~&h&¾§¢GzÉsÔ;jÝK)×Í×Jô-ëw¡;c_gÝ\ªKçOc¾XùÉJ>zõ~äðvü'ÃM5:Éqî»êó}.Ëi·ØB´mÛ÷¡=}CßhÕ|ªMÇÏd¶xù¹PJ:¢5¦îr$'ÍJÍ 9jIÿ½æþg¤ìîmÀ_B|wÙ.jþ/IPêmôQ,½À×Ù@º!:²ÝÄKË3ùÐLObmWMÝxËoR^X|ì»B$<sà%¦cjý'XÉ·#Psßaá¼©17ÏaÒ¸ùñ LKBíXEÜÝv»oQVxz"ì³R#4FqÀ%¥mÎê ØÉÁüÞ(	<Î­ò = D'7b×QÐ(Ù=M¼áH(ZbHµ§¤?ÚÉwÄ;lÝK*uÍÒ6t-ðèfGÞäg½Ê-|èÛ(\{= %¤;ió¿XËÃ·¢1Óße¹¼ªA÷ÏeÂ¸úÑÐI7mQeÜÞ~ûoUFØvºé{ÈÓ'TFy@%£3NiñÇØËÏÃø(LN­úà <Ì"W"×Uð(Úí¼ã@¨Y ïd@5§¨_ÚÊûi}ÃÝäK,ÍÖVt.÷wÂý¶
2&-ø,Od%MrË!Læw %¨[jûÿXÊ·¤ASßcÙ<©9wÏcâ8ùÐKGmU=}\ÝtÛoSfØ~úëHÃ"Du %§SNjùØÊÂ Î(
8­ö  LL&G¢¯ R¢èò¡±ÉµÅ7²áglo'~ggn¨gN¥hÚõ¹m½CsíO­!BåÚåU 8ÎV!üvØ6»UÅ§*
dCé¯Ô=}>Êüw£-Ç/Ã-òNö7µMN{Ìº5&ÝTNö)0¼®+Ñ?oð¸zé½î99ÒëÇ°Ãö®$KÞ³¢à%RþÉÀÇ!B­IàÇXLóHDØR 3iå]ûXµµÑ¡8?9¤/_Â¢¹¤ò¥eÖþ°|<Ñî,.}4¡÷+%AÌÿªºÿýÆÀÓr)¿©8á«Ù¨ÐÜìYðE=  Wþ0A5ý×¯Ìk ¤Ú(¢à¥­ÜÖ/DÐ!\WZp48XBååp§@'ä­*Ãa± °ðØÿ¥oðAÝ«odð±±±pÀ³=MðÌ³pQ÷ð(s¶pO2	ð§K¹pÎdð(¼pâðê¿p ªð±±ÂpÀð{pÄpnÌ ðÉ*Çp©Ïþð~ÜÊpåÊüð{Ìp9»úð¢-Ïp»¤÷ðÕÌÒpõð÷cÔp¨Zóðëó×pD)ñð{ÙpnïïðÖýÜp@­ìðvÞpÓcêð²éápAèðSãp¤µæ½¶²±á±³rÐN=Mb¥
£­¾w¶$atâ=MÍÉÞåS"e÷¤@8¢Ã ÞÏxí@¨á
ÕDz×ÊþNëÑ±É¹óÉ@ú= fv³Uç|'P¾dKîL¬ªÑ}Øªï{¤
oLÀ¤-K -îP¬âÁ¼Óçwù]=}JÊôbåW=}vI<nâÉ<ãçx]?ÎtbíW,=}x«I@®ÑÞýÄËúÜXJe$ËûüXZe&ËüXje(Ëý<XzeªåKP¬ÚWÀs¹É·1³Ä±ÓËýW(0	k¥pì«Pd¦+ðl«@¬díëÐl|_¤dïkÐl|_¬dÏKÀlv_ªbOKàl~_ªdÜÀ't_mFÐl£o{Lªd\À¸l«s_¯a\ Èl«w_¯b\@Øl«{_¯c\èl«_¯d|´l-a|¼l­a|Äl-b|Ìl­b|Ôl-c|Ülo®â*>+@¨tegî ,ì4déDdêTdëddl4liDljTlkdlL2
I:IB
JJJR
KZKb
Lj|ñÇãB>=}ÖäzGãF^=}Þ$1ß59_=}AßEI_MQßUY_]aßei_mäq³Äás»äáuÃâwË$âyÓDã{ÛdW|ÃÎ²Ásá½Nç;fú¤üÏA¨ìP¬¤/¯mJð¬°J-zL­D/L¯ÂïÆ/ÊoÎ¯¢Âð¢Æ0¢Êp¢Î°îÇI±±±±ò	ä{Î+IïWH+KoWhàîW¥K/$«ÿ ðð@­C0£¯{ ªàð­K0¤$¯ ªðÏu8)Âðú-:è¢ØÏvX)Æp
-<(¢àÏwx)Êð->h¢èÏx)Îp*-@¨¢°Ý:±1±ñb}Ïõ=}j¦¢Ñïu<©Â üm:ð¢Ùïv\©Æm<0¢áïw|©Ê mª ÐKx¢êx )Ï.­¸£4-Ò0yØ£<-Ô°yø£D-Ö0z£L-Ø°z8£T-Ú0{X£\-Ü°{x£d-Þ0|£l-à°|¸¤t-â0}Ø¤|-ä°}ø¤-æ0~¤-è°~8¤-ê0X¤-ì°x¤¤-î0¤¬-ð°PÝò²±ÑÁµR°/Q¶¤2ªr-¯áPI}èÐ¤B­Õz£J­×z0£R­Ù{P£Z­Û{p£b­Ý|£j­ß|°£r­á}Ð¤z­ãí°íÐîðîî0îPîp.o¬ïò¡1Á¹±±±gggg÷' T]okÜ^kw^mK]pÃ[Q>Ï{YR:¿«YQ?ÇkÙ¾f
ææÆ6ûZWB'+ÚXGëXC+Wù¢Eë¨Ué¬mD ì¤M¤ ÓF½czÔJåãzÒPÅzÓHµúWKg*×LWêLk
KáZã{ß= {ÝX­ûà\ÃÖo£« o¥Ì p¨£ o¤¯ü]crç,Ýdw×ìdsëczè'%x.=M(|Èßf÷fLeûfSÖr±ÌíAò´ÄÍ¡ò²ÎÝ!ò1Õ[É<Øc;ÔoÙS<Ö_¹Bó¾Ô¡ó¿Þ}!sÀÖ¥as¾ÂY=}îyT>ê©T=}ïiÔ÷=M
±ÍþÃñOiw]/ÝgNb*ggéoOÏXfl¬{Ôóy£·¨ÂØa2d^¦¦PPµ§®¬= °mq¹G=MâwñrÈ%¤r»WËØgÑJ¹G~Ì¹kv\µ´QëýÉ9´@·¡¢´R³áC2<Ç·ahÈI1[9µ2ºÉZqÑy=}1;ìiIñ7ÀËºïÑº÷§ùåJ3=}Éå	¡¶PÁ[¶ÔÏ¢ñgUÜñSÊye¼ÊøÑÛ1AüÌ#»òy{¶ªÍ÷óÌ8üü?Jç=Më_5¨HT_-º&X$ðÛ=}Á³úÝ«VyÓEÕmÃúöÓÜ·Þ¿Üzç½/NÀßa[ÉÏ4OyØÍ?©!ÀÐ³ÈÒ¡1d¬¥Ú!³ðâ!EjáDø :*Ä/©ãÔphDìR+ôyT^ªÇe·NºN½ñÌG«ÏeÎZP °pe os¹ohâÍÏÎÏÍÒ~bm{maRrê¨ê¨*sªº=M 9úýOüùN JüJ|Ëí ÛèHHJÛ%«=}©¢zQ79©S3#$ZZ!VbwºÎ½Í¢Ð¢E|(Å¼à !H®?êj=MPíUæÏãÍ_ãEå^ÊJJÔ:BÜ²¤ï¾rê
FæJÎntr´r®r$Ïü;æÊ$U|àÈxpt¢¬M\_î=MßÚß[FÌ|½÷ôø+£û0¢5jD®mË´#stØ&Â.RÔBo2/ø®Ç­lßXÛ'ì®öh£ Ç^ûM= ÀK»<<[¼+ônovÉùÊþMúÍþÍú
=}¿ê|(\ràØEAæÒáõRüþE0ÈüO~±­nPõ6{vt|xð±Àµú¯¯}Ë¯üÕ!®Æ8|ZJï<8k
jjcª¿GNÙÅ)Ö<µRsN7©}0rã$âùàO/âüö|	ÆtlÎiÿÜ¨aeýÿ¬Mõ|/£ÇÔéwYmïwwm&Ò¼"',@bbÎMªlèé®$Ín§//IÜP-®Ëü,j¥û' ôM¯ëÏ)LÂ¡£ØIð²`});var o,a,l,c,u,d={a:{b:t=>Math.cos(t),a:t=>Math.exp(t),c:(t,s,e)=>r.copyWithin(t,s,s+e),d(t){r.length,(t=>{throw"OOM"})()}}};this.o=s=>{t.o(n,s)},this.l=()=>t.l(n),this.instantiate=()=>(this.l().then((t=>WebAssembly.instantiate(t,d))).then((t=>{const e=t.exports;var i;o=e.g,a=e.h,l=e.i,c=e.j,u=e.k,i=(h=e.e).buffer,r=new Uint8Array(i),(t=>{t.f()})(e),s()})),this.ready=new Promise((t=>{s=t})).then((()=>{this.J=h.buffer,this.O=a,this.free=u,this.Y=o,this.H=l,this.F=c})),this)}function h(t={}){h._||Object.defineProperties(h,{_:{value:new Map([[-1,"OPUS_BAD_ARG: One or more invalid/out of range arguments"],[-2,"OPUS_BUFFER_TOO_SMALL: Not enough bytes allocated in the buffer"],[-3,"OPUS_INTERNAL_ERROR: An internal error was detected"],[-4,"OPUS_INVALID_PACKET: The compressed data passed is corrupted"],[-5,"OPUS_UNIMPLEMENTED: Invalid/unsupported request number"],[-6,"OPUS_INVALID_STATE: An encoder or decoder structure is invalid or already freed"],[-7,"OPUS_ALLOC_FAIL: Memory allocation has failed"]])}}),this.K=()=>new this.X(this).instantiate(this.Z,this.tt).then((t=>{this.st=t,this.et=0,this.it=0,this.rt=0,this.nt=this.st.A(this.ht,Uint8Array),this.ot=this.st.A(this.lt*this.ct,Float32Array);const s=this.st.A(this.ut,Uint8Array);s.N.set(this.dt),this.Ut=this.st.U.Y(this.Mt,this.ut,this.ft,this.gt,s.S,this.wt,this.yt)})),Object.defineProperty(this,"ready",{enumerable:!0,get:()=>this.bt}),this.reset=()=>(this.free(),this.K()),this.free=()=>{this.st.free(),this.st.U.F(this.Ut),this.st.U.free(this.Ut)},this._t=t=>{if(!(t instanceof Uint8Array))throw Error("Data to decode must be Uint8Array. Instead got "+typeof t);this.nt.N.set(t);let s,e=this.st.U.H(this.Ut,this.nt.S,t.length,this.ot.S);return e<0&&(s="libopus "+e+" "+(h._.get(e)||"Unknown Error"),console.error(s),e=0),{outputBuffer:this.st.v(this.ot.N,this.lt,e),samplesDecoded:e,error:s}},this.decodeFrame=t=>{let s=[];const e=this._t(t);return e.error&&this.st.I(s,e.error,t.length,this.rt,this.et,this.it),this.rt++,this.et+=t.length,this.it+=e.samplesDecoded,this.X.T(s,[e.outputBuffer],this.lt,e.samplesDecoded,this.Mt)},this.decodeFrames=t=>{let s=[],e=[],i=0,r=0;for(;r<t.length;){const n=t[r++],h=this._t(n);s.push(h.outputBuffer),i+=h.samplesDecoded,h.error&&this.st.I(e,h.error,n.length,this.rt,this.et,this.it),this.rt++,this.et+=n.length,this.it+=h.samplesDecoded}return this.X.T(e,s,this.lt,i,this.Mt)},this.Tt=h.V,this.X=h.B||e,this.Z=h.W||n,this.tt=h.module;const s=t=>"number"==typeof t,i=t.sampleRate,r=t.$t,o=t.Pt,a=t.vt,l=t.xt,c=t.At,u=t.Ot?1:0;if(r>2&&(!s(o)||!s(a)||!Array.isArray(l)))throw Error("Invalid Opus Decoder Options for multichannel decoding.");return this.Mt=[8e3,12e3,16e3,24e3,48e3].includes(i)?i:48e3,this.ut=s(r)?r:2,this.ft=s(o)?o:1,this.gt=s(a)?a:this.ut-1,this.dt=l||(2===this.ut?[0,1]:[0]),this.wt=c||0,this.yt=r<=8&&2!=r?u:0,this.ht=3840*this.ut,this.ct=5760,this.lt=this.yt?2:this.ut,this.bt=this.K(),this}class o extends i{constructor(t){super(t,"opus-decoder",h,n)}async decodeFrame(t){return this.q("decodeFrame",t)}async decodeFrames(t){return this.q("decodeFrames",t)}}r(h,"OpusDecoder"),r(o,"OpusDecoderWebWorker");const a=Symbol,l=(()=>{const t="left",s="center",e="right";return["","front ","side ","rear "].map((i=>[[t,e],[t,e,s],[t,s,e],[s,t,e],[s]].flatMap((t=>t.map((t=>i+t)).join(", ")))))})(),c="LFE",u="monophonic (mono)",d="stereo",U="surround",M=(t,...s)=>`${[u,d,"linear "+U,"quadraphonic","5.0 "+U,"5.1 "+U,"6.1 "+U,"7.1 "+U][t-1]} (${s.join(", ")})`,f=[u,M(2,l[0][0]),M(3,l[0][2]),M(4,l[1][0],l[3][0]),M(5,l[1][2],l[3][0]),M(6,l[1][2],l[3][0],c),M(7,l[1][2],l[2][0],l[3][4],c),M(8,l[1][2],l[2][0],l[3][0],c)],p=48e3,g=44100,m=32e3,w=24e3,y=22050,b=16e3,_=8e3,T="absoluteGranulePosition",$="bandwidth",P="bitDepth",v="bitrate",x=v+"Maximum",A=v+"Minimum",O=v+"Nominal",C="buffer",S=C+"Fullness",D="codec",j=D+"Frames",N="coupledStreamCount",J="crc",L=J+"16",z=J+"32",I="data",k="description",B="duration",Q="emphasis",W="hasOpusPadding",V="header",G="isContinuedPacket",R="isCopyrighted",q="isFirstPage",Y="isHome",H="isLastPage",F="isOriginal",K="isPrivate",X="isVbr",E="layer",Z="length",tt="mode",st=tt+"Extension",et="mpeg",it=et+"Version",rt="numberAACFrames",nt="outputGain",ht="preSkip",ot="profile",at=a(),lt="protection",ct="segments",ut="subarray",dt="version",Ut="vorbis",Mt=Ut+"Comments",ft=Ut+"Setup",pt="block",gt=pt+"ingStrategy",mt=a(),wt=pt+"Size",yt=pt+"size0",bt=pt+"size1",_t=a(),Tt="channel",$t=Tt+"MappingFamily",Pt=Tt+"MappingTable",vt=Tt+"Mode",xt=a(),At=Tt+"s",Ot="copyright",Ct=Ot+"Id",St=Ot+"IdStart",Dt="frame",jt=Dt+"Count",Nt=Dt+"Length",Jt="Number",Lt=Dt+Jt,zt=Dt+"Padding",It=Dt+"Size",kt="Rate",Bt="inputSample"+kt,Qt="page",Wt=Qt+"Checksum",Vt=a(),Gt=Qt+"SegmentTable",Rt=Qt+"Sequence"+Jt,qt="sample",Yt=qt+Jt,Ht=qt+kt,Ft=a(),Kt=qt+"s",Xt="stream",Et=Xt+"Count",Zt=Xt+"Info",ts=Xt+"Serial"+Jt,ss=Xt+"StructureVersion",es="total",is=es+"BytesOut",rs=es+"Duration",ns=es+"Samples",hs=a(),os=a(),as=a(),ls=a(),cs=a(),us=a(),ds=a(),Us=a(),Ms=a(),fs=a(),ps=a(),gs=a(),ms=a(),ws=a(),ys=a(),bs=a(),_s=a(),Ts=a(),$s=Uint8Array,Ps=DataView,vs="reserved",xs="bad",As="free",Os="none",Cs="16bit CRC",Ss=(t,s,e)=>{for(let i=0;i<t[Z];i++){let r=s(i);for(let t=8;t>0;t--)r=e(r);t[i]=r}return t},Ds=Ss(new $s(256),(t=>t),(t=>128&t?7^t<<1:t<<1)),js=[Ss(new Uint16Array(256),(t=>t<<8),(t=>t<<1^(32768&t?32773:0)))],Ns=[Ss(new Uint32Array(256),(t=>t),(t=>t>>>1^3988292384*(1&t)))];for(let bi=0;bi<15;bi++){js.push(new Uint16Array(256)),Ns.push(new Uint32Array(256));for(let t=0;t<=255;t++)js[bi+1][t]=js[0][js[bi][t]>>>8]^js[bi][t]<<8,Ns[bi+1][t]=Ns[bi][t]>>>8^Ns[0][255&Ns[bi][t]]}const Js=t=>{const s=t[Z],e=s-16;let i=0,r=0;for(;r<=e;)i=Ns[15][255&(t[r++]^i)]^Ns[14][255&(t[r++]^i>>>8)]^Ns[13][255&(t[r++]^i>>>16)]^Ns[12][t[r++]^i>>>24]^Ns[11][t[r++]]^Ns[10][t[r++]]^Ns[9][t[r++]]^Ns[8][t[r++]]^Ns[7][t[r++]]^Ns[6][t[r++]]^Ns[5][t[r++]]^Ns[4][t[r++]]^Ns[3][t[r++]]^Ns[2][t[r++]]^Ns[1][t[r++]]^Ns[0][t[r++]];for(;r!==s;)i=Ns[0][255&(i^t[r++])]^i>>>8;return-1^i},Ls=(...t)=>{const s=new $s(t.reduce(((t,s)=>t+s[Z]),0));return t.reduce(((t,e)=>(s.set(e,t),t+e[Z])),0),s},zs=t=>String.fromCharCode(...t),Is=[0,8,4,12,2,10,6,14,1,9,5,13,3,11,7,15],ks=t=>Is[15&t]<<4|Is[t>>4];class Bs{constructor(t){this.Ct=t,this.St=8*t[Z]}set position(t){this.St=t}get position(){return this.St}read(t){const s=Math.floor(this.St/8),e=this.St%8;return this.St-=t,(ks(this.Ct[s-1])<<8)+ks(this.Ct[s])>>7-e&255}}class Qs{constructor(t,s){this.Dt=t,this.jt=s,this[ys]()}[bs](){this.Nt=!0}[ys](){this.Jt=new Map,this.Lt=new WeakMap,this.zt=!1,this.It=!1,this.kt=null,this.Nt=!1}[ws](t,s){if(this.jt){this.kt!==t&&(this.kt=t,this.It=!0);const e=this.Lt.get(this.Jt.get(this.Qt));this.It&&e&&this.jt({Wt:t,...e},s),this.It=!1}}[Ms](t){const s=this.Jt.get(t);return s&&this.Gt(t),s}[fs](t,s,e){this.Nt&&(this.zt||(this.Dt({...s}),this.zt=!0),this.Gt(t),this.Jt.set(t,s),this.Lt.set(s,e))}Gt(t){this.jt&&t!==this.Qt&&(this.It=!0,this.Qt=t)}}const Ws=new WeakMap,Vs=new WeakMap;class Gs{constructor(t,s){this.qt=t,this.Jt=s}*[ds](){let t;for(;;){if(t=yield*this.Ht[ps](this.qt,this.Jt,0),t)return t;this.qt[os](1)}}*[Us](t){let s=yield*this[ds]();const e=Vs.get(s)[Z];if(t||this.qt.Kt||(yield*this.Xt[Ms](this.qt,this.Jt,e)))return this.Jt[bs](),this.qt[os](e),this.qt[ls](s),s;this.qt[cs](`Missing ${Dt} at ${e} bytes from current position.`,`Dropping current ${Dt} and trying again.`),this.Jt[ys](),this.qt[os](1)}}class Rs{constructor(t,s){Vs.set(this,{[V]:t}),this[I]=s}}class qs extends Rs{static*[ps](t,s,e,i,r){const n=yield*t[Ms](e,i,r);if(n){const t=Ws.get(n)[Nt],i=Ws.get(n)[Kt];return new s(n,(yield*e[hs](t,r))[ut](0,t),i)}return null}constructor(t,s,e){super(t,s),this[V]=t,this[Kt]=e,this[B]=e/t[Ht]*1e3,this[Lt]=null,this[is]=null,this[ns]=null,this[rs]=null,Vs.get(this)[Z]=s[Z]}}const Ys="unsynchronizationFlag",Hs="extendedHeaderFlag",Fs="experimentalFlag",Ks="footerPresent";class Xs{static*Zt(t,s,e){const i={};let r=yield*t[hs](3,e);if(73!==r[0]||68!==r[1]||51!==r[2])return null;if(r=yield*t[hs](10,e),i[dt]=`id3v2.${r[3]}.${r[4]}`,15&r[5])return null;if(i[Ys]=!!(128&r[5]),i[Hs]=!!(64&r[5]),i[Fs]=!!(32&r[5]),i[Ks]=!!(16&r[5]),128&r[6]||128&r[7]||128&r[8]||128&r[9])return null;const n=r[6]<<21|r[7]<<14|r[8]<<7|r[9];return i[Z]=10+n,new Xs(i)}constructor(t){this[dt]=t[dt],this[Ys]=t[Ys],this[Hs]=t[Hs],this[Fs]=t[Fs],this[Ks]=t[Ks],this[Z]=t[Z]}}class Es{constructor(t){Ws.set(this,t),this[P]=t[P],this[v]=null,this[At]=t[At],this[vt]=t[vt],this[Ht]=t[Ht]}}const Zs={0:[As,As,As,As,As],16:[32,32,32,32,8],240:[xs,xs,xs,xs,xs]},te=(t,s,e)=>8*((t+e)%s+s)*(1<<(t+e)/s)-8*s*(s/8|0);for(let bi=2;bi<15;bi++)Zs[bi<<4]=[32*bi,te(bi,4,0),te(bi,4,-1),te(bi,8,4),te(bi,8,0)];const se="bands ",ee=" to 31",ie={0:se+4+ee,16:se+8+ee,32:se+12+ee,48:se+16+ee},re="bitrateIndex",ne="v2",he="v1",oe="Intensity stereo ",ae=", MS stereo ",le="on",ce="off",ue={0:{[k]:vs},2:{[k]:"Layer III",[zt]:1,[st]:{0:oe+ce+ae+ce,16:oe+le+ae+ce,32:oe+ce+ae+le,48:oe+le+ae+le},[he]:{[re]:2,[Kt]:1152},[ne]:{[re]:4,[Kt]:576}},4:{[k]:"Layer II",[zt]:1,[st]:ie,[Kt]:1152,[he]:{[re]:1},[ne]:{[re]:4}},6:{[k]:"Layer I",[zt]:4,[st]:ie,[Kt]:384,[he]:{[re]:0},[ne]:{[re]:3}}},de="MPEG Version ",Ue="ISO/IEC ",Me={0:{[k]:de+"2.5 (later extension of MPEG 2)",[E]:ne,[Ht]:{0:11025,4:12e3,8:_,12:vs}},8:{[k]:vs},16:{[k]:`${de}2 (${Ue}13818-3)`,[E]:ne,[Ht]:{0:y,4:w,8:b,12:vs}},24:{[k]:`${de}1 (${Ue}11172-3)`,[E]:he,[Ht]:{0:g,4:p,8:m,12:vs}},length:Z},fe={0:Cs,1:Os},pe={0:Os,1:"50/15 ms",2:vs,3:"CCIT J.17"},ge={0:{[At]:2,[k]:d},64:{[At]:2,[k]:"joint "+d},128:{[At]:2,[k]:"dual channel"},192:{[At]:1,[k]:u}};class me extends Es{static*[Ms](t,s,e){const i={},r=yield*Xs.Zt(t,s,e);r&&(yield*t[hs](r[Z],e),t[os](r[Z]));const n=yield*t[hs](4,e),h=zs(n[ut](0,4)),o=s[Ms](h);if(o)return new me(o);if(255!==n[0]||n[1]<224)return null;const a=Me[24&n[1]];if(a[k]===vs)return null;const l=6&n[1];if(ue[l][k]===vs)return null;const c={...ue[l],...ue[l][a[E]]};if(i[it]=a[k],i[E]=c[k],i[Kt]=c[Kt],i[lt]=fe[1&n[1]],i[Z]=4,i[v]=Zs[240&n[2]][c[re]],i[v]===xs)return null;if(i[Ht]=a[Ht][12&n[2]],i[Ht]===vs)return null;if(i[zt]=2&n[2]&&c[zt],i[K]=!!(1&n[2]),i[Nt]=Math.floor(125*i[v]*i[Kt]/i[Ht]+i[zt]),!i[Nt])return null;const u=192&n[3];if(i[vt]=ge[u][k],i[At]=ge[u][At],i[st]=c[st][48&n[3]],i[R]=!!(8&n[3]),i[F]=!!(4&n[3]),i[Q]=pe[3&n[3]],i[Q]===vs)return null;i[P]=16;{const{length:t,frameLength:e,ts:r,...n}=i;s[fs](h,i,n)}return new me(i)}constructor(t){super(t),this[v]=t[v],this[Q]=t[Q],this[zt]=t[zt],this[R]=t[R],this[F]=t[F],this[K]=t[K],this[E]=t[E],this[st]=t[st],this[it]=t[it],this[lt]=t[lt]}}class we extends qs{static*[ps](t,s,e){return yield*super[ps](me,we,t,s,e)}constructor(t,s,e){super(t,s,e)}}class ye extends Gs{constructor(t,s,e){super(t,s),this.Ht=we,this.Xt=me,e(this[D])}get[D](){return et}*[gs](){return yield*this[Us]()}}const be={0:"MPEG-4",8:"MPEG-2"},_e={0:"valid",2:xs,4:xs,6:xs},Te={0:Cs,1:Os},$e={0:"AAC Main",64:"AAC LC (Low Complexity)",128:"AAC SSR (Scalable Sample Rate)",192:"AAC LTP (Long Term Prediction)"},Pe={0:96e3,4:88200,8:64e3,12:p,16:g,20:m,24:w,28:y,32:b,36:12e3,40:11025,44:_,48:7350,52:vs,56:vs,60:"frequency is written explicitly"},ve={0:{[At]:0,[k]:"Defined in AOT Specific Config"},64:{[At]:1,[k]:u},128:{[At]:2,[k]:M(2,l[0][0])},192:{[At]:3,[k]:M(3,l[1][3])},256:{[At]:4,[k]:M(4,l[1][3],l[3][4])},320:{[At]:5,[k]:M(5,l[1][3],l[3][0])},384:{[At]:6,[k]:M(6,l[1][3],l[3][0],c)},448:{[At]:8,[k]:M(8,l[1][3],l[2][0],l[3][0],c)}};class xe extends Es{static*[Ms](t,s,e){const i={},r=yield*t[hs](7,e),n=zs([r[0],r[1],r[2],252&r[3]|3&r[6]]),h=s[Ms](n);if(h)Object.assign(i,h);else{if(255!==r[0]||r[1]<240)return null;if(i[it]=be[8&r[1]],i[E]=_e[6&r[1]],i[E]===xs)return null;const t=1&r[1];i[lt]=Te[t],i[Z]=t?7:9,i[at]=192&r[2],i[Ft]=60&r[2];const e=2&r[2];if(i[ot]=$e[i[at]],i[Ht]=Pe[i[Ft]],i[Ht]===vs)return null;i[K]=!!e,i[xt]=448&(r[2]<<8|r[3]),i[vt]=ve[i[xt]][k],i[At]=ve[i[xt]][At],i[F]=!!(32&r[3]),i[Y]=!!(8&r[3]),i[Ct]=!!(8&r[3]),i[St]=!!(4&r[3]),i[P]=16,i[Kt]=1024,i[rt]=3&r[6];{const{length:t,rs:e,ns:r,hs:h,frameLength:o,ts:a,os:l,...c}=i;s[fs](n,i,c)}}if(i[Nt]=8191&(r[3]<<11|r[4]<<3|r[5]>>5),!i[Nt])return null;const o=2047&(r[5]<<6|r[6]>>2);return i[S]=2047===o?"VBR":o,new xe(i)}constructor(t){super(t),this[Ct]=t[Ct],this[St]=t[St],this[S]=t[S],this[Y]=t[Y],this[F]=t[F],this[K]=t[K],this[E]=t[E],this[Z]=t[Z],this[it]=t[it],this[rt]=t[rt],this[ot]=t[ot],this[lt]=t[lt]}get ls(){const t=Ws.get(this),s=t[at]+64<<5|t[Ft]<<5|t[xt]>>3,e=new $s(2);return new Ps(e[C]).setUint16(0,s,!1),e}}class Ae extends qs{static*[ps](t,s,e){return yield*super[ps](xe,Ae,t,s,e)}constructor(t,s,e){super(t,s,e)}}class Oe extends Gs{constructor(t,s,e){super(t,s),this.Ht=Ae,this.Xt=xe,e(this[D])}get[D](){return"aac"}*[gs](){return yield*this[Us]()}}class Ce extends qs{static cs(t){return(t[t[Z]-2]<<8)+t[t[Z]-1]}static[Ts](t){const s=Ce.cs(t),e=(t=>{const s=t[Z],e=s-16;let i=0,r=0;for(;r<=e;)i^=t[r++]<<8|t[r++],i=js[15][i>>8]^js[14][255&i]^js[13][t[r++]]^js[12][t[r++]]^js[11][t[r++]]^js[10][t[r++]]^js[9][t[r++]]^js[8][t[r++]]^js[7][t[r++]]^js[6][t[r++]]^js[5][t[r++]]^js[4][t[r++]]^js[3][t[r++]]^js[2][t[r++]]^js[1][t[r++]]^js[0][t[r++]];for(;r!==s;)i=(255&i)<<8^js[0][i>>8^t[r++]];return i})(t[ut](0,-2));return s===e}constructor(t,s,e){s[Zt]=e,s[L]=Ce.cs(t),super(s,t,Ws.get(s)[Kt])}}const Se="get from STREAMINFO metadata block",De={0:"Fixed",1:"Variable"},je={0:vs,16:192};for(let bi=2;bi<16;bi++)je[bi<<4]=bi<6?576*2**(bi-2):2**bi;const Ne={0:Se,1:88200,2:176400,3:192e3,4:_,5:b,6:y,7:w,8:m,9:g,10:p,11:96e3,15:xs},Je={0:{[At]:1,[k]:u},16:{[At]:2,[k]:M(2,l[0][0])},32:{[At]:3,[k]:M(3,l[0][1])},48:{[At]:4,[k]:M(4,l[1][0],l[3][0])},64:{[At]:5,[k]:M(5,l[1][1],l[3][0])},80:{[At]:6,[k]:M(6,l[1][1],c,l[3][0])},96:{[At]:7,[k]:M(7,l[1][1],c,l[3][4],l[2][0])},112:{[At]:8,[k]:M(8,l[1][1],c,l[3][0],l[2][0])},128:{[At]:2,[k]:d+" (left, diff)"},144:{[At]:2,[k]:d+" (diff, right)"},160:{[At]:2,[k]:d+" (avg, diff)"},176:vs,192:vs,208:vs,224:vs,240:vs},Le={0:Se,2:8,4:12,6:vs,8:16,10:20,12:24,14:vs};class ze extends Es{static ds(t){if(t[0]>254)return null;if(t[0]<128)return{value:t[0],length:1};let s=1;for(let n=64;n&t[0];n>>=1)s++;let e=s-1,i=0,r=0;for(;e>0;r+=6,e--){if(128!=(192&t[e]))return null;i|=(63&t[e])<<r}return i|=(t[e]&127>>s)<<r,{value:i,length:s}}static[_s](t,s){const e={*[hs](){return t}};return ze[Ms](e,s,0).next().value}static*[Ms](t,s,e){let i=yield*t[hs](6,e);if(255!==i[0]||248!==i[1]&&249!==i[1])return null;const r={},n=zs(i[ut](0,4)),h=s[Ms](n);if(h)Object.assign(r,h);else{if(r[mt]=1&i[1],r[gt]=De[r[mt]],r[_t]=240&i[2],r[Ft]=15&i[2],r[wt]=je[r[_t]],r[wt]===vs)return null;if(r[Ht]=Ne[r[Ft]],r[Ht]===xs)return null;if(1&i[3])return null;const t=Je[240&i[3]];if(t===vs)return null;if(r[At]=t[At],r[vt]=t[k],r[P]=Le[14&i[3]],r[P]===vs)return null}r[Z]=5,i=yield*t[hs](r[Z]+8,e);const o=ze.ds(i[ut](4));if(!o)return null;if(r[mt]?r[Yt]=o.value:r[Lt]=o.value,r[Z]+=o[Z],96===r[_t]?(i[Z]<r[Z]&&(i=yield*t[hs](r[Z],e)),r[wt]=i[r[Z]-1]+1,r[Z]+=1):112===r[_t]&&(i[Z]<r[Z]&&(i=yield*t[hs](r[Z],e)),r[wt]=(i[r[Z]-1]<<8)+i[r[Z]]+1,r[Z]+=2),r[Kt]=r[wt],12===r[Ft]?(i[Z]<r[Z]&&(i=yield*t[hs](r[Z],e)),r[Ht]=1e3*i[r[Z]-1],r[Z]+=1):13===r[Ft]?(i[Z]<r[Z]&&(i=yield*t[hs](r[Z],e)),r[Ht]=(i[r[Z]-1]<<8)+i[r[Z]],r[Z]+=2):14===r[Ft]&&(i[Z]<r[Z]&&(i=yield*t[hs](r[Z],e)),r[Ht]=10*((i[r[Z]-1]<<8)+i[r[Z]]),r[Z]+=2),i[Z]<r[Z]&&(i=yield*t[hs](r[Z],e)),r[J]=i[r[Z]-1],r[J]!==(t=>{let s=0;const e=t[Z];for(let i=0;i!==e;i++)s=Ds[s^t[i]];return s})(i[ut](0,r[Z]-1)))return null;if(!h){const{fs:t,frameNumber:e,ps:i,ts:h,hs:o,gs:a,ws:l,length:c,...u}=r;s[fs](n,r,u)}return new ze(r)}constructor(t){super(t),this[L]=null,this[gt]=t[gt],this[wt]=t[wt],this[Lt]=t[Lt],this[Yt]=t[Yt],this[Zt]=null}}class Ie extends Gs{constructor(t,s,e){super(t,s),this.Ht=Ce,this.Xt=ze,e(this[D])}get[D](){return"flac"}*ys(t){const s=yield*this.qt[hs](2,0),e=s[Z]-2;for(;t<e;){if(255===s[t]){const e=s[t+1];if(248===e||249===e)break;255!==e&&t++}t++}return t}*[gs](){for(;;){const t=yield*ze[Ms](this.qt,this.Jt,0);if(t){let s=Ws.get(t)[Z]+2;for(;s<=524288;){if(this.qt.Kt||(yield*ze[Ms](this.qt,this.Jt,s))){let e=yield*this.qt[hs](s);if(this.qt.Kt||(e=e[ut](0,s)),Ce[Ts](e)){const i=new Ce(e,t);return this.Jt[bs](),this.qt[os](s),this.qt[ls](i),i}}s=yield*this.ys(s+1)}this.qt[cs](`Unable to sync FLAC frame after searching ${s} bytes.`),this.qt[os](s)}else this.qt[os](yield*this.ys(1))}}[ms](t){return 0===t[Rt]?(this.Jt[bs](),this._s=t[I][ut](13)):1===t[Rt]||(t[j]=Vs.get(t)[ct].map((t=>{const s=ze[_s](t,this.Jt);if(s)return new Ce(t,s,this._s);this.qt[cs]("Failed to parse Ogg FLAC frame","Skipping invalid FLAC frame")})).filter((t=>!!t))),t}}class ke{static*[Ms](t,s,e){const i={};let r=yield*t[hs](28,e);if(79!==r[0]||103!==r[1]||103!==r[2]||83!==r[3])return null;if(i[ss]=r[4],248&r[5])return null;i[H]=!!(4&r[5]),i[q]=!!(2&r[5]),i[G]=!!(1&r[5]);const n=new Ps($s.from(r[ut](0,28))[C]);try{i[T]=n.getBigInt64(6,!0)}catch{}i[ts]=n.getInt32(14,!0),i[Rt]=n.getInt32(18,!0),i[Wt]=n.getInt32(22,!0);const h=r[26];i[Z]=h+27,r=yield*t[hs](i[Z],e),i[Nt]=0,i[Gt]=[],i[Vt]=$s.from(r[ut](27,i[Z]));for(let o=0,a=0;o<h;o++){const t=i[Vt][o];i[Nt]+=t,a+=t,255===t&&o!==h-1||(i[Gt].push(a),a=0)}return new ke(i)}constructor(t){Ws.set(this,t),this[T]=t[T],this[G]=t[G],this[q]=t[q],this[H]=t[H],this[Gt]=t[Gt],this[Rt]=t[Rt],this[Wt]=t[Wt],this[ts]=t[ts]}}class Be extends Rs{static*[ps](t,s,e){const i=yield*ke[Ms](t,s,e);if(i){const s=Ws.get(i)[Nt],e=Ws.get(i)[Z],r=e+s,n=(yield*t[hs](r,0))[ut](0,r),h=n[ut](e,r);return new Be(i,h,n)}return null}constructor(t,s,e){super(t,s),Vs.get(this)[Z]=e[Z],this[j]=[],this.Ts=e,this[T]=t[T],this[z]=t[Wt],this[B]=0,this[G]=t[G],this[q]=t[q],this[H]=t[H],this[Rt]=t[Rt],this[Kt]=0,this[ts]=t[ts]}}class Qe extends qs{constructor(t,s){super(s,t,s[It]*s[jt]/1e3*s[Ht])}}const We={0:f.slice(0,2),1:f},Ve="SILK-only",Ge="CELT-only",Re="Hybrid",qe="narrowband",Ye="medium-band",He="wideband",Fe="super-wideband",Ke="fullband",Xe={0:{[tt]:Ve,[$]:qe,[It]:10},8:{[tt]:Ve,[$]:qe,[It]:20},16:{[tt]:Ve,[$]:qe,[It]:40},24:{[tt]:Ve,[$]:qe,[It]:60},32:{[tt]:Ve,[$]:Ye,[It]:10},40:{[tt]:Ve,[$]:Ye,[It]:20},48:{[tt]:Ve,[$]:Ye,[It]:40},56:{[tt]:Ve,[$]:Ye,[It]:60},64:{[tt]:Ve,[$]:He,[It]:10},72:{[tt]:Ve,[$]:He,[It]:20},80:{[tt]:Ve,[$]:He,[It]:40},88:{[tt]:Ve,[$]:He,[It]:60},96:{[tt]:Re,[$]:Fe,[It]:10},104:{[tt]:Re,[$]:Fe,[It]:20},112:{[tt]:Re,[$]:Ke,[It]:10},120:{[tt]:Re,[$]:Ke,[It]:20},128:{[tt]:Ge,[$]:qe,[It]:2.5},136:{[tt]:Ge,[$]:qe,[It]:5},144:{[tt]:Ge,[$]:qe,[It]:10},152:{[tt]:Ge,[$]:qe,[It]:20},160:{[tt]:Ge,[$]:He,[It]:2.5},168:{[tt]:Ge,[$]:He,[It]:5},176:{[tt]:Ge,[$]:He,[It]:10},184:{[tt]:Ge,[$]:He,[It]:20},192:{[tt]:Ge,[$]:Fe,[It]:2.5},200:{[tt]:Ge,[$]:Fe,[It]:5},208:{[tt]:Ge,[$]:Fe,[It]:10},216:{[tt]:Ge,[$]:Fe,[It]:20},224:{[tt]:Ge,[$]:Ke,[It]:2.5},232:{[tt]:Ge,[$]:Ke,[It]:5},240:{[tt]:Ge,[$]:Ke,[It]:10},248:{[tt]:Ge,[$]:Ke,[It]:20}};class Ee extends Es{static[_s](t,s,e){const i={};if(i[At]=t[9],i[$t]=t[18],i[Z]=0!==i[$t]?21+i[At]:19,t[Z]<i[Z])throw Error("Out of data while inside an Ogg Page");const r=3&s[0],n=3===r?2:1,h=zs(t[ut](0,i[Z]))+zs(s[ut](0,n)),o=e[Ms](h);if(o)return new Ee(o);if("OpusHead"!==h.substr(0,8))return null;if(1!==t[8])return null;i[I]=$s.from(t[ut](0,i[Z]));const a=new Ps(i[I][C]);if(i[P]=16,i[ht]=a.getUint16(10,!0),i[Bt]=a.getUint32(12,!0),i[Ht]=p,i[nt]=a.getInt16(16,!0),i[$t]in We&&(i[vt]=We[i[$t]][i[At]-1],!i[vt]))return null;0!==i[$t]&&(i[Et]=t[19],i[N]=t[20],i[Pt]=[...t[ut](21,i[At]+21)]);const l=Xe[248&s[0]];switch(i[tt]=l[tt],i[$]=l[$],i[It]=l[It],r){case 0:i[jt]=1;break;case 1:case 2:i[jt]=2;break;case 3:i[X]=!!(128&s[1]),i[W]=!!(64&s[1]),i[jt]=63&s[1];break;default:return null}{const{length:t,data:s,$s:r,...n}=i;e[fs](h,i,n)}return new Ee(i)}constructor(t){super(t),this[I]=t[I],this[$]=t[$],this[$t]=t[$t],this[Pt]=t[Pt],this[N]=t[N],this[jt]=t[jt],this[It]=t[It],this[W]=t[W],this[Bt]=t[Bt],this[X]=t[X],this[tt]=t[tt],this[nt]=t[nt],this[ht]=t[ht],this[Et]=t[Et]}}class Ze extends Gs{constructor(t,s,e){super(t,s),this.Ht=Qe,this.Xt=Ee,e(this[D]),this.Ps=null}get[D](){return"opus"}[ms](t){return 0===t[Rt]?(this.Jt[bs](),this.Ps=t[I]):1===t[Rt]||(t[j]=Vs.get(t)[ct].map((t=>{const s=Ee[_s](this.Ps,t,this.Jt);if(s)return new Qe(t,s);this.qt[us]("Failed to parse Ogg Opus Header","Not a valid Ogg Opus file")}))),t}}class ti extends qs{constructor(t,s,e){super(s,t,e)}}const si={};for(let bi=0;bi<8;bi++)si[bi+6]=2**(6+bi);class ei extends Es{static[_s](t,s,e,i){if(t[Z]<30)throw Error("Out of data while inside an Ogg Page");const r=zs(t[ut](0,30)),n=s[Ms](r);if(n)return new ei(n);const h={[Z]:30};if("vorbis"!==r.substr(0,7))return null;h[I]=$s.from(t[ut](0,30));const o=new Ps(h[I][C]);if(h[dt]=o.getUint32(7,!0),0!==h[dt])return null;if(h[At]=t[11],h[vt]=f[h[At]-1]||"application defined",h[Ht]=o.getUint32(12,!0),h[x]=o.getInt32(16,!0),h[O]=o.getInt32(20,!0),h[A]=o.getInt32(24,!0),h[bt]=si[(240&t[28])>>4],h[yt]=si[15&t[28]],h[yt]>h[bt])return null;if(1!==t[29])return null;h[P]=32,h[ft]=i,h[Mt]=e;{const{length:t,data:e,version:i,vs:n,xs:o,...a}=h;s[fs](r,h,a)}return new ei(h)}constructor(t){super(t),this[x]=t[x],this[A]=t[A],this[O]=t[O],this[yt]=t[yt],this[bt]=t[bt],this[I]=t[I],this[Mt]=t[Mt],this[ft]=t[ft]}}class ii extends Gs{constructor(t,s,e){super(t,s),this.Ht=ti,e(this[D]),this.Ps=null,this.As=!1,this.Os=null}get[D](){return Ut}[ms](t){t[j]=[];for(const s of Vs.get(t)[ct])if(1===s[0])this.Jt[bs](),this.Ps=t[I],this.As=!1;else if(3===s[0])this.Cs=s;else if(5===s[0])this.Ss=s,this.Ds=this.js(s),this.As=!0;else if(this.As){const e=ei[_s](this.Ps,this.Jt,this.Cs,this.Ss);e?t[j].push(new ti(s,e,this.Ns(s,e))):this.qt[logError]("Failed to parse Ogg Vorbis Header","Not a valid Ogg Vorbis file")}return t}Ns(t,s){const e=this.Ds.Js[t[0]>>1&this.Ds.mask]?s[bt]:s[yt],i=null===this.Os?0:(this.Os+e)/4;return this.Os=e,i}js(t){const s=new Bs(t),e={count:0,Js:[]};for(;1!=(1&s.read(1)););let i;for(;e.count<64&&s.position>0;){ks(s.read(8));let t=0;for(;0===s.read(8)&&t++<3;);if(4!==t){1+((126&ks(i))>>1)!==e.count&&this.qt[cs]("vorbis derived mode count did not match actual mode count");break}i=s.read(7),e.Js.unshift(1&i),s.position+=6,e.count++}return e.mask=(1<<Math.log2(e.count))-1,e}}class ri{constructor(t,s,e){this.qt=t,this.Jt=s,this.Ls=e,this.zs=new $s,this.Is=null,this.ks=null}get[D](){return this.Is||""}Bs(t,s){this.Is!==t&&(this.Jt[ys](),this.Qs=new s(this.qt,this.Jt,this.Ls),this.Is=t)}Ws({data:t}){const s=zs(t[ut](0,8));switch(s){case"fishead\0":return!1;case"OpusHead":return this.Bs("opus",Ze),!0;case/^\x7fFLAC/.test(s)&&s:return this.Bs("flac",Ie),!0;case/^\x01vorbis/.test(s)&&s:return this.Bs(Ut,ii),!0;default:return!1}}Vs(t){t[Rt]!==this.Gs+1&&this.Gs>1&&t[Rt]>1&&this.qt[cs]("Unexpected gap in Ogg Page Sequence Number.",`Expected: ${this.Gs+1}, Got: ${t[Rt]}`),this.Gs=t[Rt]}Rs(t){null===this.ks&&(this.Gs=t[Rt],this.ks=this.Ws(t)),this.Vs(t);const s=Vs.get(t),e=Ws.get(s[V]);let i=0;if(s[ct]=e[Gt].map((s=>t[I][ut](i,i+=s))),this.zs[Z]&&(s[ct][0]=Ls(this.zs,s[ct][0]),this.zs=new $s),255===e[Vt][e[Vt][Z]-1]&&(this.zs=Ls(this.zs,s[ct].pop())),this.ks){const s=this.Qs[ms](t);return this.qt[ls](s),s}return t}}class ni extends Gs{constructor(t,s,e){super(t,s),this.Ls=e,this.Ht=Be,this.Xt=ke,this.qs=new Map,this.Ys=null}get[D](){const t=this.qs.get(this.Ys);return t?t.ss:""}*[gs](){const t=yield*this[Us](!0);this.Ys=t[ts];let s=this.qs.get(this.Ys);return s||(s=new ri(this.qt,this.Jt,this.Ls),this.qs.set(this.Ys,s)),t[H]&&this.qs.delete(this.Ys),s.Rs(t)}}const hi=()=>{};class oi{constructor(t,{Hs:s,Fs:e,Ks:i,Xs:r=!1,Es:n=!0}={}){this.Zs=t,this.Ls=s||hi,this.Dt=e||hi,this.jt=i,this.te=r,this.se=n?Js:hi,this[ys]()}get[D](){return this.Qs?this.Qs[D]:""}[ys](){this.Jt=new Qs(this.Dt,this.jt),this.ee=this.ie(),this.ee.next()}*flush(){this.Kt=!0;for(let t=this.ee.next();t.value;t=this.ee.next())yield t.value;this.Kt=!1,this[ys]()}*re(t){for(let s=this.ee.next(t);s.value;s=this.ee.next())yield s.value}parseAll(t){return[...this.re(t),...this.flush()]}*ie(){if(this.Zs.match(/aac/))this.Qs=new Oe(this,this.Jt,this.Ls);else if(this.Zs.match(/mpeg/))this.Qs=new ye(this,this.Jt,this.Ls);else if(this.Zs.match(/flac/))this.Qs=new Ie(this,this.Jt,this.Ls);else{if(!this.Zs.match(/ogg/))throw Error("Unsupported Codec "+mimeType);this.Qs=new ni(this,this.Jt,this.Ls)}for(this.rt=0,this.ne=0,this.he=0,this.oe=0,this.ae=0,this.Mt=void 0,this.le=new Uint8Array(0);;){const t=yield*this.Qs[gs]();t&&(yield t)}}*[hs](t=0,s=0){let e;for(;this.le[Z]<=t+s;){if(e=yield,this.Kt)return this.le[ut](s);e&&(this.he+=e[Z],this.le=Ls(this.le,e))}return this.le[ut](s)}[os](t){this.ne+=t,this.le=this.le[ut](t)}[as](t){this.Mt=t[V][Ht],t[V][v]=t[B]>0?8*Math.round(t[I][Z]/t[B]):0,t[Lt]=this.rt++,t[is]=this.oe,t[ns]=this.ae,t[rs]=this.ae/this.Mt*1e3,t[z]=this.se(t[I]),this.Jt[ws](t[V][v],t[rs]),this.oe+=t[I][Z],this.ae+=t[Kt]}[ls](t){t[j]?(t[j].forEach((s=>{t[B]+=s[B],t[Kt]+=s[Kt],this[as](s)})),t[ns]=this.ae,t[rs]=this.ae/this.Mt*1e3||0,t[is]=this.oe):this[as](t)}Ue(t,s){if(this.te){const e=[`${D}:         ${this[D]}`,"inputMimeType: "+this.Zs,"readPosition:  "+this.ne,"totalBytesIn:  "+this.he,`${is}: ${this.oe}`],i=Math.max(...e.map((t=>t[Z])));s.push("--stats--"+"-".repeat(i-9),...e,"-".repeat(i)),t("codec-parser",s.reduce(((t,s)=>t+"\n  "+s),""))}}[cs](...t){this.Ue(console.warn,t)}[us](...t){this.Ue(console.error,t)}}const ai=T,li=j,ci=N,ui=I,di=V,Ui=H,Mi=ht,fi=Pt,pi=At,gi=Kt,mi=Et;class wi{constructor(t={}){this.Mt=t.sampleRate||48e3,this.yt=void 0!==t.Ot&&t.Ot,this.Ls=t=>{if("opus"!==t)throw Error("ogg-opus-decoder does not support this codec "+t)},new e,this.pe=h,this.K()}K(){this.Ut&&this.Ut.free(),this.Ut=null,this.bt=Promise.resolve(),this.qt=new oi("application/ogg",{Hs:this.Ls,Es:!1})}async ge(t){this.me=0,this.wt=t[Mi],this.ut=this.yt?2:t[pi],this.we=null,this.Ut=new this.pe({$t:t[pi],Pt:t[mi],vt:t[ci],xt:t[fi],At:Math.round(this.wt/48e3*this.Mt),sampleRate:this.Mt,Ot:this.yt}),await this.Ut.ready}get ready(){return this.bt}async reset(){this.K()}free(){this.K()}async _t(t){let s=[],e=[],i=0;for await(const r of t){const t=r[li].map((t=>t[ui]));if(t.length){this.Ut||await this.ge(r[li][0][di]);const{channelData:n,samplesDecoded:h,_:o}=await this.Ut.decodeFrames(t);if(this.me+=h,null===this.we&&Number(r[ai])>-1&&(this.we=r[ai]-BigInt(r[gi])+BigInt(this.wt)),r[Ui]){if(void 0!==r[ai]){const t=this.me/this.Mt*48e3,s=Number(r[ai]-this.we),e=Math.round((t-s)/48e3*this.Mt);for(let i=0;i<n.length;i++)n[i]=n[i].subarray(0,h-e);i-=e}this.K()}s.push(...o),e.push(n),i+=h}}return[s,e,this.ut,i,this.Mt,16]}ye(t){return[...this.qt.re(t)]}be(){return[...this.qt.flush()]}async decode(t){const s=await this._t(this.ye(t));return e.T(...s)}async decodeFile(t){const s=await this._t([...this.ye(t),...this.be()]);return this.K(),e.T(...s)}async flush(){const t=await this._t(this.be());return this.K(),e.T(...t)}}class yi extends wi{constructor(t){super(t),this.pe=o}async free(){super.free()}}r(wi,"OggOpusDecoder"),r(yi,"OggOpusDecoderWebWorker"),t.OggOpusDecoder=wi,t.OggOpusDecoderWebWorker=yi},"object"==typeof exports&&"undefined"!=typeof module?s(exports,require("@eshaz/web-worker")):"function"==typeof define&&define.amd?define(["exports","@eshaz/web-worker"],s):s((t="undefined"!=typeof globalThis?globalThis:t||self)["ogg-opus-decoder"]={},t.Worker);
//# sourceMappingURL=ogg-opus-decoder.min.js.map